/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.enums;

import io.fincast.util.SimDate;
import java.util.Locale;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\b\u0086\u0001\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0013B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\bJ&\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\bJ\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0014"}, d2={"Lio/fincast/enums/Periodicity;", "", "months", "", "(Ljava/lang/String;II)V", "getMonths", "()I", "endOfPeriod", "Lio/fincast/util/SimDate;", "date", "isCashflowDate", "", "startDate", "endDate", "startOfPeriod", "MATURITY", "MONTHLY", "QUARTERLY", "YEARLY", "Companion", "fincast"})
@SourceDebugExtension(value={"SMAP\nPeriodicity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Periodicity.kt\nio/fincast/enums/Periodicity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,41:1\n1#2:42\n*E\n"})
public final class Periodicity
extends Enum<Periodicity> {
    @NotNull
    public static final Companion Companion;
    private final int months;
    public static final int MONTHS_IN_YEAR = 12;
    public static final /* enum */ Periodicity MATURITY;
    public static final /* enum */ Periodicity MONTHLY;
    public static final /* enum */ Periodicity QUARTERLY;
    public static final /* enum */ Periodicity YEARLY;
    private static final /* synthetic */ Periodicity[] $VALUES;

    private Periodicity(int months) {
        this.months = months;
    }

    public final int getMonths() {
        return this.months;
    }

    @NotNull
    public final SimDate startOfPeriod(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.months == 0 ? date : SimDate.Companion.of(date.year(), (date.month() - 1) / this.months * this.months + 1);
    }

    @NotNull
    public final SimDate endOfPeriod(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.months == 0 ? date : this.startOfPeriod(date).plus(this.months).minus(1);
    }

    public final boolean isCashflowDate(@NotNull SimDate date, @Nullable SimDate startDate, @Nullable SimDate endDate) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        if (startDate != null && date.compareTo(startDate) < 0) {
            return false;
        }
        if (endDate != null && date.compareTo(endDate) > 0) {
            return false;
        }
        if (endDate != null && Intrinsics.areEqual((Object)date, (Object)endDate)) {
            return true;
        }
        if (MATURITY == this) {
            return false;
        }
        boolean bl2 = bl = 0 < this.months;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "months > 0";
            throw new AssertionError((Object)string);
        }
        return date.month() % this.months == 0;
    }

    public static /* synthetic */ boolean isCashflowDate$default(Periodicity periodicity, SimDate simDate, SimDate simDate2, SimDate simDate3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: isCashflowDate");
        }
        if ((n & 2) != 0) {
            simDate2 = null;
        }
        if ((n & 4) != 0) {
            simDate3 = null;
        }
        return periodicity.isCashflowDate(simDate, simDate2, simDate3);
    }

    public final boolean isCashflowDate(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.isCashflowDate(date, null, null);
    }

    public static Periodicity[] values() {
        return (Periodicity[])$VALUES.clone();
    }

    public static Periodicity valueOf(String value) {
        return Enum.valueOf(Periodicity.class, value);
    }

    static {
        MATURITY = new Periodicity(0);
        MONTHLY = new Periodicity(1);
        QUARTERLY = new Periodicity(3);
        YEARLY = new Periodicity(12);
        $VALUES = periodicityArray = new Periodicity[]{Periodicity.MATURITY, Periodicity.MONTHLY, Periodicity.QUARTERLY, Periodicity.YEARLY};
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/fincast/enums/Periodicity$Companion;", "", "()V", "MONTHS_IN_YEAR", "", "of", "Lio/fincast/enums/Periodicity;", "periodicity", "", "fincast"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Periodicity of(@NotNull String periodicity) {
            Intrinsics.checkNotNullParameter((Object)periodicity, (String)"periodicity");
            String string = periodicity;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            String string2 = string.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(locale)");
            return Periodicity.valueOf(string2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

