package io.fincast.portfolio

object ValueProviders {

	@JvmStatic
	fun <T> constValue(value: T): ValueProvider<T> {
		return ValueProvider { value }
	}

	@JvmStatic
	fun eomBalance(pos: Position): ValueProvider<Double> {
		return ValueProvider { date ->
			return@ValueProvider pos.getBalance(date - 1)
		}
	}

	@JvmStatic
	fun eomCreditBalance(pos: Position): ValueProvider<Double> {
		return ValueProvider { date ->
			val eomBalance = pos.getBalance(date - 1)
			return@ValueProvider eomBalance.coerceAtLeast(0.0)
		}
	}

	@JvmStatic
	fun eomDebitBalance(pos: Position): ValueProvider<Double> {
		return ValueProvider { date ->
			val eomBalance = pos.getBalance(date - 1)
			return@ValueProvider eomBalance.coerceAtMost(0.0)
		}
	}

}
