package io.fincast.household

import io.fincast.enums.Periodicity
import io.fincast.util.SimDate

/**
 * A periodic aggregate for a holding.
 *
 * First level of aggregation, reports the eop balance and yield of the holding at a certain date.
 */
data class HoldingAggregate(
	val holding: Holding,
	val date: SimDate,
	val balance: Double,
	val yield: Double,
	val inflows: Double,
	val outflows: Double,
	val gain: Double,
) {

	override fun toString(): String {
		return "${date}: ${holding.tag} [${String.format("%.0f", balance)}, ${String.format("%.0f", yield)}] {->${String.format("%.0f", inflows)}, ${String.format("%.0f", outflows)}->, ${String.format("%.0f", gain)}}"
	}

}

/**
 * A periodic aggregate for a household.
 *
 * Second level of aggregation, reports the eop balance and yield of the household at a certain date.
 */
data class HouseholdAggregate(
	val date: SimDate,
	val assets: Double,
	val liabilities: Double,
	val yield: Double,
	val inflows: Double,
	val outflows: Double,
	val gain: Double,
) {

	override fun toString(): String {
		return "${date}: [${String.format("%.0f", assets)}, ${String.format("%.0f", liabilities)}, ${String.format("%.0f", yield)}] {->${String.format("%.0f", inflows)}, ${String.format("%.0f", outflows)}->, ${String.format("%.0f", gain)}}"
	}

}

data class ProjectionResult(
	val reconDate: SimDate,
	val endDate: SimDate,
	val periodicity: Periodicity,
	val holdings: List<Holding>,
	val pocketMoney: Holding,
	val externalMoney: Holding,
	val householdAggregates: List<HouseholdAggregate>,
	val holdingAggregates: List<HoldingAggregate>,
	val bookings: List<Booking>,
)
