package io.fincast.household

import io.fincast.enums.Periodicity
import io.fincast.household.impl.HouseholdImpl
import io.fincast.portfolio.Portfolio
import io.fincast.util.SimDate

interface Household {

	val persons: List<Person>

	val reconDate: SimDate

	val holdings: List<Holding>

	val pocketMoney: Holding

	val externalMoney: Holding

	val portfolio: Portfolio

	fun calcProjection(endDate: SimDate, periodicity: Periodicity = Periodicity.MONTHLY): ProjectionResult

	class Builder {
		private var persons: List<Person> = emptyList()
		private var reconDate: SimDate? = null
		private var holdings: List<Holding> = emptyList()
		fun persons(persons: List<Person>) = apply { this.persons = persons }
		fun reconDate(reconDate: SimDate) = apply { this.reconDate = reconDate }
		fun holdings(holdings: List<Holding>) = apply { this.holdings = holdings }
		fun build(): Household {
			return HouseholdImpl(
				persons = persons,
				reconDate = reconDate ?: throw IllegalArgumentException("reconDate is required"),
				holdings = holdings,
			)
		}
	}

	companion object {

		const val POCKET_MONEY_TAG = "#pocketMoney"
		const val EXTERNAL_MONEY_TAG = "#externalMoney"

		@JvmStatic
		fun createHousehold(persons: List<Person>, reconDate: SimDate, holdings: List<Holding>): Household {
			return Builder()
				.persons(persons)
				.reconDate(reconDate)
				.holdings(holdings)
				.build()
		}

	}

}
