package io.fincast.household

import io.fincast.enums.BookingKind
import io.fincast.util.SimDate

sealed interface Booking {
	val holding: Holding
	val date: SimDate
	val bookingKind: BookingKind
	val amount: Double
}

/**
 * A reconciliation half-booking on a holding.
 *
 * A reconciliation booking sets the balance of a holding at the given date.
 */
data class ReconciliationBooking(
	override val holding: Holding,
	override val date: SimDate,
	override val amount: Double,
) : Booking {

	override val bookingKind = BookingKind.RECONCILE

	override fun toString(): String {
		return "${date}: ${bookingKind.code} ${holding.tag} ${String.format("%.0f", amount)}"
	}

}

/**
 * A half-booking on a holding, triggered by a position component lifecycle.
 */
data class LifecycleBooking(
	override val holding: Holding,
	override val date: SimDate,
	override val bookingKind: BookingKind,
	override val amount: Double,
	val refHolding: Holding,
	val refCompo: String,
) : Booking {

	override fun toString(): String {
		return "${date}: ${bookingKind.code} ${holding.tag} ${String.format("%.0f", amount)} (${refHolding.tag}:${refCompo})"
	}

}
