/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.pos.model.impl;

import io.fincast.household.model.enums.ProductType;
import io.fincast.pos.model.Booking;
import io.fincast.pos.model.BookingPeriod;
import io.fincast.pos.model.Portfolio;
import io.fincast.pos.model.Position;
import io.fincast.pos.model.PositionCompo;
import io.fincast.pos.model.SimDate;
import io.fincast.pos.model.enums.BookingKind;
import io.fincast.pos.model.impl.PortfolioImpl;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ*\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u0016J\u0018\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u001dH\u0016J\u0018\u0010!\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u001dH\u0016J\u0010\u0010#\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0010\u0010&\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010'\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\nH\u0016J\u0010\u0010+\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010,\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010-\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006."}, d2={"Lio/fincast/pos/model/impl/PositionImpl;", "Lio/fincast/pos/model/Position;", "portfolio", "Lio/fincast/pos/model/Portfolio;", "tag", "", "productType", "Lio/fincast/household/model/enums/ProductType;", "(Lio/fincast/pos/model/Portfolio;Ljava/lang/String;Lio/fincast/household/model/enums/ProductType;)V", "compos", "", "Lio/fincast/pos/model/PositionCompo;", "getCompos", "()Ljava/util/List;", "setCompos", "(Ljava/util/List;)V", "getPortfolio", "()Lio/fincast/pos/model/Portfolio;", "getProductType", "()Lio/fincast/household/model/enums/ProductType;", "getTag", "()Ljava/lang/String;", "addBooking", "", "date", "Lio/fincast/pos/model/SimDate;", "bookingKind", "Lio/fincast/pos/model/enums/BookingKind;", "amount", "", "refPos", "addReconciliation", "balance", "addTurnover", "turnover", "getBalance", "getBookings", "Lio/fincast/pos/model/Booking;", "getCapitalGain", "getDividendAccrual", "getInterestAccrual", "getPeriods", "Lio/fincast/pos/model/BookingPeriod;", "getTurnover", "handlePortfolioLifecycle", "handlePositionLifecycle", "fincast"})
@SourceDebugExtension(value={"SMAP\nPositionImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PositionImpl.kt\nio/fincast/pos/model/impl/PositionImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1855#2,2:64\n*S KotlinDebug\n*F\n+ 1 PositionImpl.kt\nio/fincast/pos/model/impl/PositionImpl\n*L\n16#1:64,2\n*E\n"})
public final class PositionImpl
implements Position {
    @NotNull
    private final Portfolio portfolio;
    @NotNull
    private final String tag;
    @NotNull
    private final ProductType productType;
    @NotNull
    private List<? extends PositionCompo> compos;

    public PositionImpl(@NotNull Portfolio portfolio, @NotNull String tag, @NotNull ProductType productType) {
        Intrinsics.checkNotNullParameter((Object)portfolio, (String)"portfolio");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)productType), (String)"productType");
        this.portfolio = portfolio;
        this.tag = tag;
        this.productType = productType;
        this.compos = CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public Portfolio getPortfolio() {
        return this.portfolio;
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @Override
    @NotNull
    public ProductType getProductType() {
        return this.productType;
    }

    @Override
    @NotNull
    public List<PositionCompo> getCompos() {
        return this.compos;
    }

    public void setCompos(@NotNull List<? extends PositionCompo> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.compos = list;
    }

    @Override
    public void handlePositionLifecycle(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Iterable $this$forEach$iv = this.getCompos();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PositionCompo it = (PositionCompo)element$iv;
            boolean bl = false;
            it.handleLifecycle(date);
        }
    }

    @Override
    public void handlePortfolioLifecycle(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
    }

    @Override
    public double getBalance(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Portfolio portfolio = this.getPortfolio();
        Intrinsics.checkNotNull((Object)portfolio, (String)"null cannot be cast to non-null type io.fincast.pos.model.impl.PortfolioImpl");
        return ((PortfolioImpl)portfolio).getBalance(this, date);
    }

    @Override
    public double getTurnover(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Portfolio portfolio = this.getPortfolio();
        Intrinsics.checkNotNull((Object)portfolio, (String)"null cannot be cast to non-null type io.fincast.pos.model.impl.PortfolioImpl");
        return ((PortfolioImpl)portfolio).getTurnover(this, date);
    }

    @Override
    public double getInterestAccrual(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Portfolio portfolio = this.getPortfolio();
        Intrinsics.checkNotNull((Object)portfolio, (String)"null cannot be cast to non-null type io.fincast.pos.model.impl.PortfolioImpl");
        return ((PortfolioImpl)portfolio).getInterestAccrual(this, date);
    }

    @Override
    public double getDividendAccrual(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Portfolio portfolio = this.getPortfolio();
        Intrinsics.checkNotNull((Object)portfolio, (String)"null cannot be cast to non-null type io.fincast.pos.model.impl.PortfolioImpl");
        return ((PortfolioImpl)portfolio).getDividendAccrual(this, date);
    }

    @Override
    public double getCapitalGain(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Portfolio portfolio = this.getPortfolio();
        Intrinsics.checkNotNull((Object)portfolio, (String)"null cannot be cast to non-null type io.fincast.pos.model.impl.PortfolioImpl");
        return ((PortfolioImpl)portfolio).getCapitalGain(this, date);
    }

    @Override
    @NotNull
    public List<Booking> getBookings(@Nullable SimDate date) {
        Portfolio portfolio = this.getPortfolio();
        Intrinsics.checkNotNull((Object)portfolio, (String)"null cannot be cast to non-null type io.fincast.pos.model.impl.PortfolioImpl");
        return ((PortfolioImpl)portfolio).getBookings(this, date);
    }

    @Override
    @NotNull
    public List<BookingPeriod> getPeriods() {
        Portfolio portfolio = this.getPortfolio();
        Intrinsics.checkNotNull((Object)portfolio, (String)"null cannot be cast to non-null type io.fincast.pos.model.impl.PortfolioImpl");
        return ((PortfolioImpl)portfolio).getPeriods(this);
    }

    @Override
    public void addReconciliation(@NotNull SimDate date, double balance) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Portfolio portfolio = this.getPortfolio();
        Intrinsics.checkNotNull((Object)portfolio, (String)"null cannot be cast to non-null type io.fincast.pos.model.impl.PortfolioImpl");
        ((PortfolioImpl)portfolio).addReconciliation(this, date, balance);
    }

    @Override
    public void addTurnover(@NotNull SimDate date, double turnover) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Portfolio portfolio = this.getPortfolio();
        Intrinsics.checkNotNull((Object)portfolio, (String)"null cannot be cast to non-null type io.fincast.pos.model.impl.PortfolioImpl");
        ((PortfolioImpl)portfolio).addTurnover(this, date, turnover);
    }

    @Override
    public void addBooking(@NotNull SimDate date, @NotNull BookingKind bookingKind, double amount, @Nullable Position refPos) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)((Object)bookingKind), (String)"bookingKind");
        Portfolio portfolio = this.getPortfolio();
        Intrinsics.checkNotNull((Object)portfolio, (String)"null cannot be cast to non-null type io.fincast.pos.model.impl.PortfolioImpl");
        ((PortfolioImpl)portfolio).addBooking(this, date, bookingKind, amount, refPos);
    }
}

