/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.pos.model.impl;

import io.fincast.pos.model.Portfolio;
import io.fincast.pos.model.Position;
import io.fincast.pos.model.PositionCompo;
import io.fincast.pos.model.SimDate;
import io.fincast.pos.model.enums.BookingKind;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\bJ \u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\b2\b\b\u0002\u0010\u0011\u001a\u00020\fJ\u001e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\b\u00a8\u0006\u0018"}, d2={"Lio/fincast/pos/model/impl/PositionCompoBase;", "Lio/fincast/pos/model/PositionCompo;", "()V", "bookAccrual", "", "date", "Lio/fincast/pos/model/SimDate;", "accrual", "", "bookingKind", "Lio/fincast/pos/model/enums/BookingKind;", "isReinvestment", "", "bookCapitalGain", "capitalGain", "bookCashflow", "amount", "isViaPocket", "bookDividendAccrual", "bookInterestAccrual", "bookTransfer", "from", "Lio/fincast/pos/model/Position;", "to", "fincast"})
public abstract class PositionCompoBase
implements PositionCompo {
    public final void bookCashflow(@NotNull SimDate date, double amount, boolean isViaPocket) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        if (!(amount == 0.0)) {
            if (isViaPocket) {
                this.getPortfolio().getPocketMoney().addBooking(date, BookingKind.TURNOVER, amount, this.getPosition());
            } else {
                Position.DefaultImpls.addBooking$default(this.getPosition(), date, BookingKind.TURNOVER, amount, null, 8, null);
            }
            this.getPortfolio().getExternalMoney().addBooking(date, BookingKind.TURNOVER, -amount, this.getPosition());
        }
    }

    public static /* synthetic */ void bookCashflow$default(PositionCompoBase positionCompoBase, SimDate simDate, double d, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: bookCashflow");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        positionCompoBase.bookCashflow(simDate, d, bl);
    }

    public final void bookTransfer(@NotNull SimDate date, @NotNull Position from, @NotNull Position to, double amount) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        if (!(amount == 0.0)) {
            from.addBooking(date, BookingKind.TRANSFER, amount, this.getPosition());
            to.addBooking(date, BookingKind.TRANSFER, -amount, this.getPosition());
        }
    }

    public final void bookInterestAccrual(@NotNull SimDate date, double accrual, boolean isReinvestment) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        this.bookAccrual(date, accrual, BookingKind.INTEREST, isReinvestment);
    }

    public final void bookDividendAccrual(@NotNull SimDate date, double accrual, boolean isReinvestment) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        this.bookAccrual(date, accrual, BookingKind.DIVIDEND, isReinvestment);
    }

    private final void bookAccrual(SimDate date, double accrual, BookingKind bookingKind, boolean isReinvestment) {
        if (!(accrual == 0.0)) {
            this.getPortfolio().getExternalMoney().addBooking(date, bookingKind, -accrual, this.getPosition());
            if (isReinvestment) {
                Position.DefaultImpls.addBooking$default(this.getPosition(), date, bookingKind, accrual, null, 8, null);
            } else {
                this.getPortfolio().getPocketMoney().addBooking(date, bookingKind, accrual, this.getPosition());
            }
        }
    }

    public final void bookCapitalGain(@NotNull SimDate date, double capitalGain) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        if (!(capitalGain == 0.0)) {
            this.getPortfolio().getExternalMoney().addBooking(date, BookingKind.CAPITAL_GAIN, -capitalGain, this.getPosition());
            Position.DefaultImpls.addBooking$default(this.getPosition(), date, BookingKind.CAPITAL_GAIN, capitalGain, null, 8, null);
        }
    }

    @Override
    @NotNull
    public Portfolio getPortfolio() {
        return PositionCompo.DefaultImpls.getPortfolio(this);
    }

    @Override
    public void handleLifecycle(@NotNull SimDate date) {
        PositionCompo.DefaultImpls.handleLifecycle(this, date);
    }
}

