/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.pos.model.impl;

import io.fincast.household.model.enums.ProductType;
import io.fincast.pos.model.Booking;
import io.fincast.pos.model.BookingPeriod;
import io.fincast.pos.model.Portfolio;
import io.fincast.pos.model.Position;
import io.fincast.pos.model.SimDate;
import io.fincast.pos.model.enums.BookingKind;
import io.fincast.pos.model.impl.BookingPeriodImpl;
import io.fincast.pos.model.impl.PortfolioImpl;
import io.fincast.pos.model.impl.PositionImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J2\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u0007J\u001e\u0010\"\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010#\u001a\u00020 J\u001e\u0010$\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010%\u001a\u00020 J \u0010&\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010'\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0003J\u0018\u0010(\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00102\u0006\u0010\u0019\u001a\u00020\u00072\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003J\u0016\u0010+\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0003J\u0016\u0010,\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0003J\u0012\u0010-\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0016\u0010.\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0003J\u0012\u0010/\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0014\u00100\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0019\u001a\u00020\u0007J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\u0006\u00101\u001a\u000202H\u0016J\u0016\u00103\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0003R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00064"}, d2={"Lio/fincast/pos/model/impl/PortfolioImpl;", "Lio/fincast/pos/model/Portfolio;", "reconDate", "Lio/fincast/pos/model/SimDate;", "(Lio/fincast/pos/model/SimDate;)V", "_bookingPeriodsByPos", "", "Lio/fincast/pos/model/Position;", "", "Lio/fincast/pos/model/BookingPeriod;", "externalMoney", "getExternalMoney", "()Lio/fincast/pos/model/Position;", "pocketMoney", "getPocketMoney", "positions", "", "getPositions", "()Ljava/util/List;", "setPositions", "(Ljava/util/List;)V", "getReconDate", "()Lio/fincast/pos/model/SimDate;", "addBooking", "", "pos", "booking", "Lio/fincast/pos/model/Booking;", "date", "bookingKind", "Lio/fincast/pos/model/enums/BookingKind;", "amount", "", "refPos", "addReconciliation", "balance", "addTurnover", "turnover", "getAccrual", "getBalance", "getBookingPeriod", "getBookingPeriods", "getBookings", "getCapitalGain", "getDividendAccrual", "getFirstDate", "getInterestAccrual", "getLastDate", "getPeriods", "tag", "", "getTurnover", "fincast"})
@SourceDebugExtension(value={"SMAP\nPortfolioImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PortfolioImpl.kt\nio/fincast/pos/model/impl/PortfolioImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n766#2:142\n857#2,2:143\n1#3:145\n*S KotlinDebug\n*F\n+ 1 PortfolioImpl.kt\nio/fincast/pos/model/impl/PortfolioImpl\n*L\n21#1:142\n21#1:143,2\n*E\n"})
public final class PortfolioImpl
implements Portfolio {
    @NotNull
    private final SimDate reconDate;
    @NotNull
    private List<? extends Position> positions;
    @NotNull
    private final Position pocketMoney;
    @NotNull
    private final Position externalMoney;
    @NotNull
    private final Map<Position, List<BookingPeriod>> _bookingPeriodsByPos;

    public PortfolioImpl(@NotNull SimDate reconDate) {
        Intrinsics.checkNotNullParameter((Object)reconDate, (String)"reconDate");
        this.reconDate = reconDate;
        this.positions = CollectionsKt.emptyList();
        this.pocketMoney = new PositionImpl(this, "#pocketMoney", ProductType.VALUABLE);
        this.externalMoney = new PositionImpl(this, "#externalMoney", ProductType.VALUABLE);
        this._bookingPeriodsByPos = new LinkedHashMap();
    }

    @Override
    @NotNull
    public SimDate getReconDate() {
        return this.reconDate;
    }

    @Override
    @NotNull
    public List<Position> getPositions() {
        return this.positions;
    }

    public void setPositions(@NotNull List<? extends Position> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.positions = list;
    }

    @Override
    @NotNull
    public Position getPocketMoney() {
        return this.pocketMoney;
    }

    @Override
    @NotNull
    public Position getExternalMoney() {
        return this.externalMoney;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Position> getPositions(@NotNull String tag) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Iterable $this$filter$iv = this.getPositions();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Position it = (Position)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getTag(), (Object)tag)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final double getBalance(@NotNull Position pos, @NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        SimDate firstDate = this.getFirstDate(pos);
        return firstDate == null || date.compareTo(firstDate) < 0 ? 0.0 : this.getBookingPeriod(pos, date).getBalance();
    }

    public final void addReconciliation(@NotNull Position pos, @NotNull SimDate date, double balance) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        PortfolioImpl.addBooking$default(this, pos, date, BookingKind.RECONCILE, balance, null, 16, null);
    }

    public final double getTurnover(@NotNull Position pos, @NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        BookingPeriod period = this.getBookingPeriod(pos, date);
        return period.getBalance() - pos.getBalance(date.minus(1));
    }

    public final void addTurnover(@NotNull Position pos, @NotNull SimDate date, double turnover) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        PortfolioImpl.addBooking$default(this, pos, date, BookingKind.TURNOVER, turnover, null, 16, null);
    }

    public final double getInterestAccrual(@NotNull Position pos, @NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.getAccrual(pos, date, BookingKind.INTEREST);
    }

    public final double getDividendAccrual(@NotNull Position pos, @NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.getAccrual(pos, date, BookingKind.DIVIDEND);
    }

    private final double getAccrual(Position pos, SimDate date, BookingKind bookingKind) {
        List<Booking> refBookings = this.getBookingPeriod(this.getExternalMoney(), date).getRefBookings(pos);
        return -refBookings.stream().filter(arg_0 -> PortfolioImpl.getAccrual$lambda$1((Function1)new Function1<Booking, Boolean>(bookingKind){
            final /* synthetic */ BookingKind $bookingKind;
            {
                this.$bookingKind = $bookingKind;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Booking b) {
                return b.getBookingKind() == this.$bookingKind;
            }
        }, arg_0)).mapToDouble(arg_0 -> PortfolioImpl.getAccrual$lambda$2((Function1)getAccrual.2.INSTANCE, arg_0)).sum();
    }

    public final double getCapitalGain(@NotNull Position pos, @NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.getBookings(pos, date).stream().filter(arg_0 -> PortfolioImpl.getCapitalGain$lambda$3(getCapitalGain.1.INSTANCE, arg_0)).mapToDouble(arg_0 -> PortfolioImpl.getCapitalGain$lambda$4((Function1)getCapitalGain.2.INSTANCE, arg_0)).sum();
    }

    @NotNull
    public final List<Booking> getBookings(@NotNull Position pos, @Nullable SimDate date) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (date != null) {
            return this.getBookingPeriod(pos, date).getBookings();
        }
        List bookings = new ArrayList();
        for (BookingPeriod period : this.getBookingPeriods(pos)) {
            bookings.addAll((Collection)period.getBookings());
        }
        return bookings;
    }

    public final void addBooking(@NotNull Position pos, @NotNull SimDate date, @NotNull BookingKind bookingKind, double amount, @Nullable Position refPos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)((Object)bookingKind), (String)"bookingKind");
        if (0.0 == amount) {
            return;
        }
        SimDate lastDate = this.getLastDate(pos);
        if (!(lastDate == null || date.compareTo(lastDate) >= 0)) {
            boolean bl = false;
            String string = "new bookingDate after lastBookingDate";
            throw new IllegalArgumentException(string.toString());
        }
        Booking booking = new Booking(date, bookingKind, amount, refPos);
        this.addBooking(pos, booking);
    }

    public static /* synthetic */ void addBooking$default(PortfolioImpl portfolioImpl, Position position, SimDate simDate, BookingKind bookingKind, double d, Position position2, int n, Object object) {
        if ((n & 0x10) != 0) {
            position2 = null;
        }
        portfolioImpl.addBooking(position, simDate, bookingKind, d, position2);
    }

    private final void addBooking(Position pos, Booking booking) {
        BookingPeriod period = this.getBookingPeriod(pos, booking.getDate());
        period.addBooking(booking);
    }

    @NotNull
    public final List<BookingPeriod> getPeriods(@NotNull Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.getBookingPeriods(pos);
    }

    private final BookingPeriod getBookingPeriod(Position pos, SimDate date) {
        SimDate firstDate = this.getFirstDate(pos);
        if (firstDate != null && date.compareTo(firstDate) < 0) {
            return new BookingPeriodImpl(pos, date);
        }
        List<BookingPeriod> bookingPeriods = this.getBookingPeriods(pos);
        SimDate simDate = firstDate;
        if (simDate == null) {
            simDate = date;
        }
        int index = date.minus(simDate);
        int i = bookingPeriods.size();
        if (i <= index) {
            while (true) {
                if (i == 0) {
                    BookingPeriodImpl period = new BookingPeriodImpl(pos, date);
                    bookingPeriods.add(period);
                } else {
                    BookingPeriod prevPeriod = bookingPeriods.get(i - 1);
                    SimDate periodDate = bookingPeriods.get(0).getDate().plus(i);
                    Intrinsics.checkNotNull((Object)prevPeriod, (String)"null cannot be cast to non-null type io.fincast.pos.model.impl.BookingPeriodImpl");
                    BookingPeriodImpl nextPeriod = ((BookingPeriodImpl)prevPeriod).copy(periodDate);
                    if (!nextPeriod.getBookings().isEmpty()) {
                        boolean $i$a$-check-PortfolioImpl$getBookingPeriod$32 = false;
                        String $i$a$-check-PortfolioImpl$getBookingPeriod$32 = "no bookings";
                        throw new IllegalStateException($i$a$-check-PortfolioImpl$getBookingPeriod$32.toString());
                    }
                    if (!(!nextPeriod.isReconciled())) {
                        boolean bl = false;
                        String string = "not reconciled";
                        throw new IllegalStateException(string.toString());
                    }
                    bookingPeriods.add(nextPeriod);
                }
                if (i == index) break;
                ++i;
            }
        }
        return bookingPeriods.get(index);
    }

    private final SimDate getFirstDate(Position pos) {
        List<BookingPeriod> bookingPeriods = this.getBookingPeriods(pos);
        return !((Collection)bookingPeriods).isEmpty() ? bookingPeriods.get(0).getDate() : null;
    }

    private final SimDate getLastDate(Position pos) {
        List<BookingPeriod> bookingPeriods = this.getBookingPeriods(pos);
        return !((Collection)bookingPeriods).isEmpty() ? bookingPeriods.get(bookingPeriods.size() - 1).getDate() : null;
    }

    private final List<BookingPeriod> getBookingPeriods(Position pos) {
        if (!this._bookingPeriodsByPos.containsKey(pos)) {
            this._bookingPeriodsByPos.put(pos, new ArrayList());
        }
        List<BookingPeriod> list = this._bookingPeriodsByPos.get(pos);
        Intrinsics.checkNotNull(list);
        return list;
    }

    private static final boolean getAccrual$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final double getAccrual$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0)).doubleValue();
    }

    private static final boolean getCapitalGain$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final double getCapitalGain$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0)).doubleValue();
    }
}

