/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.pos.model.impl;

import io.fincast.household.model.enums.RevenueAllocation;
import io.fincast.pos.model.Position;
import io.fincast.pos.model.SimDate;
import io.fincast.pos.model.ValueProvider;
import io.fincast.pos.model.impl.PositionCompoBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u000bH\u00c6\u0003JG\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\t\u0010$\u001a\u00020%H\u00d6\u0001J\t\u0010&\u001a\u00020\u0005H\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006'"}, d2={"Lio/fincast/pos/model/impl/InterestCompo;", "Lio/fincast/pos/model/impl/PositionCompoBase;", "position", "Lio/fincast/pos/model/Position;", "tag", "", "amount", "Lio/fincast/pos/model/ValueProvider;", "", "interestRate", "revenueAllocation", "Lio/fincast/household/model/enums/RevenueAllocation;", "(Lio/fincast/pos/model/Position;Ljava/lang/String;Lio/fincast/pos/model/ValueProvider;Lio/fincast/pos/model/ValueProvider;Lio/fincast/household/model/enums/RevenueAllocation;)V", "getAmount", "()Lio/fincast/pos/model/ValueProvider;", "getInterestRate", "getPosition", "()Lio/fincast/pos/model/Position;", "getRevenueAllocation", "()Lio/fincast/household/model/enums/RevenueAllocation;", "getTag", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "handleLifecycle", "", "date", "Lio/fincast/pos/model/SimDate;", "hashCode", "", "toString", "fincast"})
public final class InterestCompo
extends PositionCompoBase {
    @NotNull
    private final Position position;
    @NotNull
    private final String tag;
    @NotNull
    private final ValueProvider<Double> amount;
    @NotNull
    private final ValueProvider<Double> interestRate;
    @NotNull
    private final RevenueAllocation revenueAllocation;

    public InterestCompo(@NotNull Position position, @NotNull String tag, @NotNull ValueProvider<Double> amount, @NotNull ValueProvider<Double> interestRate, @NotNull RevenueAllocation revenueAllocation) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        Intrinsics.checkNotNullParameter(interestRate, (String)"interestRate");
        Intrinsics.checkNotNullParameter((Object)((Object)revenueAllocation), (String)"revenueAllocation");
        this.position = position;
        this.tag = tag;
        this.amount = amount;
        this.interestRate = interestRate;
        this.revenueAllocation = revenueAllocation;
    }

    @Override
    @NotNull
    public Position getPosition() {
        return this.position;
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @NotNull
    public final ValueProvider<Double> getAmount() {
        return this.amount;
    }

    @NotNull
    public final ValueProvider<Double> getInterestRate() {
        return this.interestRate;
    }

    @NotNull
    public final RevenueAllocation getRevenueAllocation() {
        return this.revenueAllocation;
    }

    @Override
    public void handleLifecycle(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        double amount = ((Number)this.amount.getValue(date)).doubleValue();
        double interestRate = ((Number)this.interestRate.getValue(date)).doubleValue();
        double accrual = amount * interestRate / (double)100 / (double)12;
        this.bookInterestAccrual(date, accrual, RevenueAllocation.REINVESTMENT == this.revenueAllocation);
    }

    @NotNull
    public final Position component1() {
        return this.position;
    }

    @NotNull
    public final String component2() {
        return this.tag;
    }

    @NotNull
    public final ValueProvider<Double> component3() {
        return this.amount;
    }

    @NotNull
    public final ValueProvider<Double> component4() {
        return this.interestRate;
    }

    @NotNull
    public final RevenueAllocation component5() {
        return this.revenueAllocation;
    }

    @NotNull
    public final InterestCompo copy(@NotNull Position position, @NotNull String tag, @NotNull ValueProvider<Double> amount, @NotNull ValueProvider<Double> interestRate, @NotNull RevenueAllocation revenueAllocation) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        Intrinsics.checkNotNullParameter(interestRate, (String)"interestRate");
        Intrinsics.checkNotNullParameter((Object)((Object)revenueAllocation), (String)"revenueAllocation");
        return new InterestCompo(position, tag, amount, interestRate, revenueAllocation);
    }

    public static /* synthetic */ InterestCompo copy$default(InterestCompo interestCompo, Position position, String string, ValueProvider valueProvider, ValueProvider valueProvider2, RevenueAllocation revenueAllocation, int n, Object object) {
        if ((n & 1) != 0) {
            position = interestCompo.position;
        }
        if ((n & 2) != 0) {
            string = interestCompo.tag;
        }
        if ((n & 4) != 0) {
            valueProvider = interestCompo.amount;
        }
        if ((n & 8) != 0) {
            valueProvider2 = interestCompo.interestRate;
        }
        if ((n & 0x10) != 0) {
            revenueAllocation = interestCompo.revenueAllocation;
        }
        return interestCompo.copy(position, string, valueProvider, valueProvider2, revenueAllocation);
    }

    @NotNull
    public String toString() {
        return "InterestCompo(position=" + this.position + ", tag=" + this.tag + ", amount=" + this.amount + ", interestRate=" + this.interestRate + ", revenueAllocation=" + this.revenueAllocation + ")";
    }

    public int hashCode() {
        int result = this.position.hashCode();
        result = result * 31 + this.tag.hashCode();
        result = result * 31 + this.amount.hashCode();
        result = result * 31 + this.interestRate.hashCode();
        result = result * 31 + this.revenueAllocation.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InterestCompo)) {
            return false;
        }
        InterestCompo interestCompo = (InterestCompo)other;
        if (!Intrinsics.areEqual((Object)this.position, (Object)interestCompo.position)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tag, (Object)interestCompo.tag)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.amount, interestCompo.amount)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.interestRate, interestCompo.interestRate)) {
            return false;
        }
        return this.revenueAllocation == interestCompo.revenueAllocation;
    }
}

