/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.pos.model.impl;

import io.fincast.household.model.enums.RevenueAllocation;
import io.fincast.pos.model.Position;
import io.fincast.pos.model.SimDate;
import io.fincast.pos.model.ValueProvider;
import io.fincast.pos.model.impl.PositionCompoBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J7\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\u0005H\u00d6\u0001R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006$"}, d2={"Lio/fincast/pos/model/impl/DividendCompo;", "Lio/fincast/pos/model/impl/PositionCompoBase;", "position", "Lio/fincast/pos/model/Position;", "tag", "", "revenueAllocation", "Lio/fincast/household/model/enums/RevenueAllocation;", "dividendYield", "Lio/fincast/pos/model/ValueProvider;", "", "(Lio/fincast/pos/model/Position;Ljava/lang/String;Lio/fincast/household/model/enums/RevenueAllocation;Lio/fincast/pos/model/ValueProvider;)V", "getDividendYield", "()Lio/fincast/pos/model/ValueProvider;", "getPosition", "()Lio/fincast/pos/model/Position;", "getRevenueAllocation", "()Lio/fincast/household/model/enums/RevenueAllocation;", "getTag", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "handleLifecycle", "", "date", "Lio/fincast/pos/model/SimDate;", "hashCode", "", "toString", "fincast"})
public final class DividendCompo
extends PositionCompoBase {
    @NotNull
    private final Position position;
    @NotNull
    private final String tag;
    @NotNull
    private final RevenueAllocation revenueAllocation;
    @NotNull
    private final ValueProvider<Double> dividendYield;

    public DividendCompo(@NotNull Position position, @NotNull String tag, @NotNull RevenueAllocation revenueAllocation, @NotNull ValueProvider<Double> dividendYield) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)revenueAllocation), (String)"revenueAllocation");
        Intrinsics.checkNotNullParameter(dividendYield, (String)"dividendYield");
        this.position = position;
        this.tag = tag;
        this.revenueAllocation = revenueAllocation;
        this.dividendYield = dividendYield;
    }

    @Override
    @NotNull
    public Position getPosition() {
        return this.position;
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @NotNull
    public final RevenueAllocation getRevenueAllocation() {
        return this.revenueAllocation;
    }

    @NotNull
    public final ValueProvider<Double> getDividendYield() {
        return this.dividendYield;
    }

    @Override
    public void handleLifecycle(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        double amount = this.getPosition().getBalance(date.startOfYear().minus(1));
        double dividendYield = ((Number)this.dividendYield.getValue(date)).doubleValue();
        double accrual = amount * dividendYield / (double)100 / (double)12;
        this.bookDividendAccrual(date, accrual, RevenueAllocation.REINVESTMENT == this.revenueAllocation);
    }

    @NotNull
    public final Position component1() {
        return this.position;
    }

    @NotNull
    public final String component2() {
        return this.tag;
    }

    @NotNull
    public final RevenueAllocation component3() {
        return this.revenueAllocation;
    }

    @NotNull
    public final ValueProvider<Double> component4() {
        return this.dividendYield;
    }

    @NotNull
    public final DividendCompo copy(@NotNull Position position, @NotNull String tag, @NotNull RevenueAllocation revenueAllocation, @NotNull ValueProvider<Double> dividendYield) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)revenueAllocation), (String)"revenueAllocation");
        Intrinsics.checkNotNullParameter(dividendYield, (String)"dividendYield");
        return new DividendCompo(position, tag, revenueAllocation, dividendYield);
    }

    public static /* synthetic */ DividendCompo copy$default(DividendCompo dividendCompo, Position position, String string, RevenueAllocation revenueAllocation, ValueProvider valueProvider, int n, Object object) {
        if ((n & 1) != 0) {
            position = dividendCompo.position;
        }
        if ((n & 2) != 0) {
            string = dividendCompo.tag;
        }
        if ((n & 4) != 0) {
            revenueAllocation = dividendCompo.revenueAllocation;
        }
        if ((n & 8) != 0) {
            valueProvider = dividendCompo.dividendYield;
        }
        return dividendCompo.copy(position, string, revenueAllocation, valueProvider);
    }

    @NotNull
    public String toString() {
        return "DividendCompo(position=" + this.position + ", tag=" + this.tag + ", revenueAllocation=" + this.revenueAllocation + ", dividendYield=" + this.dividendYield + ")";
    }

    public int hashCode() {
        int result = this.position.hashCode();
        result = result * 31 + this.tag.hashCode();
        result = result * 31 + this.revenueAllocation.hashCode();
        result = result * 31 + this.dividendYield.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DividendCompo)) {
            return false;
        }
        DividendCompo dividendCompo = (DividendCompo)other;
        if (!Intrinsics.areEqual((Object)this.position, (Object)dividendCompo.position)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tag, (Object)dividendCompo.tag)) {
            return false;
        }
        if (this.revenueAllocation != dividendCompo.revenueAllocation) {
            return false;
        }
        return Intrinsics.areEqual(this.dividendYield, dividendCompo.dividendYield);
    }
}

