/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.pos.model.impl;

import io.fincast.pos.model.Position;
import io.fincast.pos.model.SimDate;
import io.fincast.pos.model.ValueProvider;
import io.fincast.pos.model.impl.PositionCompoBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lio/fincast/pos/model/impl/CapitalGainCompo;", "Lio/fincast/pos/model/impl/PositionCompoBase;", "position", "Lio/fincast/pos/model/Position;", "tag", "", "capitalGainRate", "Lio/fincast/pos/model/ValueProvider;", "", "(Lio/fincast/pos/model/Position;Ljava/lang/String;Lio/fincast/pos/model/ValueProvider;)V", "getCapitalGainRate", "()Lio/fincast/pos/model/ValueProvider;", "getPosition", "()Lio/fincast/pos/model/Position;", "getTag", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "handleLifecycle", "", "date", "Lio/fincast/pos/model/SimDate;", "hashCode", "", "toString", "fincast"})
public final class CapitalGainCompo
extends PositionCompoBase {
    @NotNull
    private final Position position;
    @NotNull
    private final String tag;
    @NotNull
    private final ValueProvider<Double> capitalGainRate;

    public CapitalGainCompo(@NotNull Position position, @NotNull String tag, @NotNull ValueProvider<Double> capitalGainRate) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter(capitalGainRate, (String)"capitalGainRate");
        this.position = position;
        this.tag = tag;
        this.capitalGainRate = capitalGainRate;
    }

    @Override
    @NotNull
    public Position getPosition() {
        return this.position;
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @NotNull
    public final ValueProvider<Double> getCapitalGainRate() {
        return this.capitalGainRate;
    }

    @Override
    public void handleLifecycle(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        double amount = this.getPosition().getBalance(date.startOfYear().minus(1));
        double capitalGainRate = ((Number)this.capitalGainRate.getValue(date)).doubleValue();
        double capitalGain = amount * capitalGainRate / (double)100 / (double)12;
        this.bookCapitalGain(date, capitalGain);
    }

    @NotNull
    public final Position component1() {
        return this.position;
    }

    @NotNull
    public final String component2() {
        return this.tag;
    }

    @NotNull
    public final ValueProvider<Double> component3() {
        return this.capitalGainRate;
    }

    @NotNull
    public final CapitalGainCompo copy(@NotNull Position position, @NotNull String tag, @NotNull ValueProvider<Double> capitalGainRate) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter(capitalGainRate, (String)"capitalGainRate");
        return new CapitalGainCompo(position, tag, capitalGainRate);
    }

    public static /* synthetic */ CapitalGainCompo copy$default(CapitalGainCompo capitalGainCompo, Position position, String string, ValueProvider valueProvider, int n, Object object) {
        if ((n & 1) != 0) {
            position = capitalGainCompo.position;
        }
        if ((n & 2) != 0) {
            string = capitalGainCompo.tag;
        }
        if ((n & 4) != 0) {
            valueProvider = capitalGainCompo.capitalGainRate;
        }
        return capitalGainCompo.copy(position, string, valueProvider);
    }

    @NotNull
    public String toString() {
        return "CapitalGainCompo(position=" + this.position + ", tag=" + this.tag + ", capitalGainRate=" + this.capitalGainRate + ")";
    }

    public int hashCode() {
        int result = this.position.hashCode();
        result = result * 31 + this.tag.hashCode();
        result = result * 31 + this.capitalGainRate.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CapitalGainCompo)) {
            return false;
        }
        CapitalGainCompo capitalGainCompo = (CapitalGainCompo)other;
        if (!Intrinsics.areEqual((Object)this.position, (Object)capitalGainCompo.position)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.tag, (Object)capitalGainCompo.tag)) {
            return false;
        }
        return Intrinsics.areEqual(this.capitalGainRate, capitalGainCompo.capitalGainRate);
    }
}

