/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.pos.model.impl;

import io.fincast.pos.model.Booking;
import io.fincast.pos.model.BookingPeriod;
import io.fincast.pos.model.Position;
import io.fincast.pos.model.SimDate;
import io.fincast.pos.model.enums.BookingType;
import io.fincast.pos.model.impl.BookingPeriodImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010\u0016\u001a\u00020\bH\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0018H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00182\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J\b\u0010\u001b\u001a\u00020\bH\u0016J\b\u0010\u001c\u001a\u00020\bH\u0016J\b\u0010\u001d\u001a\u00020\rH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lio/fincast/pos/model/impl/BookingPeriodImpl;", "Lio/fincast/pos/model/BookingPeriod;", "position", "Lio/fincast/pos/model/Position;", "date", "Lio/fincast/pos/model/SimDate;", "(Lio/fincast/pos/model/Position;Lio/fincast/pos/model/SimDate;)V", "_balance", "", "_bookings", "", "Lio/fincast/pos/model/Booking;", "_isReconciled", "", "getDate", "()Lio/fincast/pos/model/SimDate;", "getPosition", "()Lio/fincast/pos/model/Position;", "addBooking", "", "booking", "copy", "getBalance", "getBookings", "", "getRefBookings", "refPos", "getTurnover", "getValue", "isReconciled", "toString", "", "fincast"})
@SourceDebugExtension(value={"SMAP\nBookingPeriodImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookingPeriodImpl.kt\nio/fincast/pos/model/impl/BookingPeriodImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public final class BookingPeriodImpl
implements BookingPeriod {
    @NotNull
    private final Position position;
    @NotNull
    private final SimDate date;
    private double _balance;
    @NotNull
    private final List<Booking> _bookings;
    private boolean _isReconciled;

    public BookingPeriodImpl(@NotNull Position position, @NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        this.position = position;
        this.date = date;
        this._bookings = new ArrayList();
    }

    @Override
    @NotNull
    public Position getPosition() {
        return this.position;
    }

    @Override
    @NotNull
    public SimDate getDate() {
        return this.date;
    }

    @Override
    public boolean isReconciled() {
        return this._isReconciled;
    }

    @Override
    public double getBalance() {
        return this._balance;
    }

    @Override
    @NotNull
    public List<Booking> getBookings() {
        return CollectionsKt.toList((Iterable)this._bookings);
    }

    @Override
    public double getTurnover() {
        return this._bookings.stream().filter(arg_0 -> BookingPeriodImpl.getTurnover$lambda$0(getTurnover.1.INSTANCE, arg_0)).mapToDouble(arg_0 -> BookingPeriodImpl.getTurnover$lambda$1((Function1)getTurnover.2.INSTANCE, arg_0)).sum();
    }

    @Override
    public double getValue() {
        return this.getPosition().getProductType().isValuable ? this.getBalance() : 0.0;
    }

    @Override
    @NotNull
    public List<Booking> getRefBookings(@NotNull Position refPos) {
        Intrinsics.checkNotNullParameter((Object)refPos, (String)"refPos");
        List<Object> list = this._bookings.stream().filter(arg_0 -> BookingPeriodImpl.getRefBookings$lambda$2((Function1)new Function1<Booking, Boolean>(refPos){
            final /* synthetic */ Position $refPos;
            {
                this.$refPos = $refPos;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Booking b) {
                return b.getRefPosition() == this.$refPos;
            }
        }, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"refPos: Position): List<\u2026=== refPos }\n\t\t\t.toList()");
        return list;
    }

    @Override
    public void addBooking(@NotNull Booking booking) {
        Intrinsics.checkNotNullParameter((Object)booking, (String)"booking");
        if (!(!this._isReconciled)) {
            boolean bl = false;
            String string = "dont add booking to reconciled period";
            throw new IllegalArgumentException(string.toString());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[booking.getBookingKind().getBookingType().ordinal()]) {
            case 1: {
                this._balance = booking.getAmount();
                this._isReconciled = true;
                break;
            }
            case 2: {
                this._balance += booking.getAmount();
            }
        }
        this._bookings.add(booking);
    }

    @NotNull
    public final BookingPeriodImpl copy(@NotNull SimDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        BookingPeriodImpl period = new BookingPeriodImpl(this.getPosition(), date);
        period._balance = this.getBalance();
        return period;
    }

    @NotNull
    public String toString() {
        double turnover = this.getTurnover();
        SimDate simDate = this.getDate();
        String string = "%.0f";
        Object[] objectArray = new Object[]{this.getBalance()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        string = "%.0f";
        objectArray = new Object[]{turnover};
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        return "BookingPeriod(" + simDate + "): " + string2 + " [turnover: " + string3 + (String)(!((Collection)this._bookings).isEmpty() ? ", Bookings: " + this._bookings : "") + "]";
    }

    private static final boolean getTurnover$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final double getTurnover$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0)).doubleValue();
    }

    private static final boolean getRefBookings$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BookingType.values().length];
            try {
                nArray[BookingType.RECONCILIATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BookingType.TURNOVER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

