/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.pos.model;

import io.fincast.pos.model.Position;
import io.fincast.pos.model.SimDate;
import io.fincast.pos.model.enums.BookingKind;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\tH\u00c6\u0003J3\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lio/fincast/pos/model/Booking;", "", "date", "Lio/fincast/pos/model/SimDate;", "bookingKind", "Lio/fincast/pos/model/enums/BookingKind;", "amount", "", "refPosition", "Lio/fincast/pos/model/Position;", "(Lio/fincast/pos/model/SimDate;Lio/fincast/pos/model/enums/BookingKind;DLio/fincast/pos/model/Position;)V", "getAmount", "()D", "getBookingKind", "()Lio/fincast/pos/model/enums/BookingKind;", "getDate", "()Lio/fincast/pos/model/SimDate;", "getRefPosition", "()Lio/fincast/pos/model/Position;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "fincast"})
public final class Booking {
    @NotNull
    private final SimDate date;
    @NotNull
    private final BookingKind bookingKind;
    private final double amount;
    @Nullable
    private final Position refPosition;

    public Booking(@NotNull SimDate date, @NotNull BookingKind bookingKind, double amount, @Nullable Position refPosition) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)((Object)bookingKind), (String)"bookingKind");
        this.date = date;
        this.bookingKind = bookingKind;
        this.amount = amount;
        this.refPosition = refPosition;
    }

    @NotNull
    public final SimDate getDate() {
        return this.date;
    }

    @NotNull
    public final BookingKind getBookingKind() {
        return this.bookingKind;
    }

    public final double getAmount() {
        return this.amount;
    }

    @Nullable
    public final Position getRefPosition() {
        return this.refPosition;
    }

    @NotNull
    public String toString() {
        String string = "%.0f";
        Object[] objectArray = new Object[]{this.amount};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return this.bookingKind + " " + string2;
    }

    @NotNull
    public final SimDate component1() {
        return this.date;
    }

    @NotNull
    public final BookingKind component2() {
        return this.bookingKind;
    }

    public final double component3() {
        return this.amount;
    }

    @Nullable
    public final Position component4() {
        return this.refPosition;
    }

    @NotNull
    public final Booking copy(@NotNull SimDate date, @NotNull BookingKind bookingKind, double amount, @Nullable Position refPosition) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)((Object)bookingKind), (String)"bookingKind");
        return new Booking(date, bookingKind, amount, refPosition);
    }

    public static /* synthetic */ Booking copy$default(Booking booking, SimDate simDate, BookingKind bookingKind, double d, Position position, int n, Object object) {
        if ((n & 1) != 0) {
            simDate = booking.date;
        }
        if ((n & 2) != 0) {
            bookingKind = booking.bookingKind;
        }
        if ((n & 4) != 0) {
            d = booking.amount;
        }
        if ((n & 8) != 0) {
            position = booking.refPosition;
        }
        return booking.copy(simDate, bookingKind, d, position);
    }

    public int hashCode() {
        int result = this.date.hashCode();
        result = result * 31 + this.bookingKind.hashCode();
        result = result * 31 + Double.hashCode(this.amount);
        result = result * 31 + (this.refPosition == null ? 0 : this.refPosition.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Booking)) {
            return false;
        }
        Booking booking = (Booking)other;
        if (!Intrinsics.areEqual((Object)this.date, (Object)booking.date)) {
            return false;
        }
        if (this.bookingKind != booking.bookingKind) {
            return false;
        }
        if (Double.compare(this.amount, booking.amount) != 0) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.refPosition, (Object)booking.refPosition);
    }
}

