/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.household.model.impl;

import io.fincast.household.model.Valuable;
import io.fincast.household.model.enums.ProductType;
import io.fincast.pos.model.Portfolio;
import io.fincast.pos.model.Position;
import io.fincast.pos.model.PositionCompo;
import io.fincast.pos.model.ValueProviders;
import io.fincast.pos.model.enums.Periodicity;
import io.fincast.pos.model.impl.CashflowCompo;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010#\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010$\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010%\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010&\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010'\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\t\u0010(\u001a\u00020\rH\u00c6\u0003Jh\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001\u00a2\u0006\u0002\u0010*J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\u0013\u00102\u001a\u00020\b2\b\u00103\u001a\u0004\u0018\u000104H\u00d6\u0003J\t\u00105\u001a\u000206H\u00d6\u0001J\t\u00107\u001a\u00020\u0003H\u00d6\u0001R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0015\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u0012\u0010\u0010R\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0007\u0010\u0013R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0015\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u0017\u0010\u0010R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0015\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u001e\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u00068"}, d2={"Lio/fincast/household/model/impl/RealEstate;", "Lio/fincast/household/model/Valuable;", "tag", "", "reconBalance", "", "fiscalValue", "isSelfOccupied", "", "imputedRentalValue", "rentalIncome", "maintenanceRate", "maintenancePeriodicity", "Lio/fincast/pos/model/enums/Periodicity;", "(Ljava/lang/String;DLjava/lang/Double;Ljava/lang/Boolean;Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;Lio/fincast/pos/model/enums/Periodicity;)V", "getFiscalValue", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getImputedRentalValue", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getMaintenancePeriodicity", "()Lio/fincast/pos/model/enums/Periodicity;", "getMaintenanceRate", "productType", "Lio/fincast/household/model/enums/ProductType;", "getProductType", "()Lio/fincast/household/model/enums/ProductType;", "getReconBalance", "()D", "getRentalIncome", "getTag", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "(Ljava/lang/String;DLjava/lang/Double;Ljava/lang/Boolean;Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;Lio/fincast/pos/model/enums/Periodicity;)Lio/fincast/household/model/impl/RealEstate;", "createCompos", "", "Lio/fincast/pos/model/PositionCompo;", "portfolio", "Lio/fincast/pos/model/Portfolio;", "pos", "Lio/fincast/pos/model/Position;", "equals", "other", "", "hashCode", "", "toString", "fincast"})
public final class RealEstate
implements Valuable {
    @NotNull
    private final String tag;
    private final double reconBalance;
    @Nullable
    private final Double fiscalValue;
    @Nullable
    private final Boolean isSelfOccupied;
    @Nullable
    private final Double imputedRentalValue;
    @Nullable
    private final Double rentalIncome;
    @Nullable
    private final Double maintenanceRate;
    @NotNull
    private final Periodicity maintenancePeriodicity;
    @NotNull
    private final ProductType productType;

    public RealEstate(@NotNull String tag, double reconBalance, @Nullable Double fiscalValue, @Nullable Boolean isSelfOccupied, @Nullable Double imputedRentalValue, @Nullable Double rentalIncome, @Nullable Double maintenanceRate, @NotNull Periodicity maintenancePeriodicity) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)maintenancePeriodicity), (String)"maintenancePeriodicity");
        this.tag = tag;
        this.reconBalance = reconBalance;
        this.fiscalValue = fiscalValue;
        this.isSelfOccupied = isSelfOccupied;
        this.imputedRentalValue = imputedRentalValue;
        this.rentalIncome = rentalIncome;
        this.maintenanceRate = maintenanceRate;
        this.maintenancePeriodicity = maintenancePeriodicity;
        this.productType = ProductType.ASSET;
    }

    public /* synthetic */ RealEstate(String string, double d, Double d2, Boolean bl, Double d3, Double d4, Double d5, Periodicity periodicity, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            d2 = null;
        }
        if ((n & 8) != 0) {
            bl = null;
        }
        if ((n & 0x10) != 0) {
            d3 = null;
        }
        if ((n & 0x20) != 0) {
            d4 = null;
        }
        if ((n & 0x40) != 0) {
            d5 = null;
        }
        if ((n & 0x80) != 0) {
            periodicity = Periodicity.YEARLY;
        }
        this(string, d, d2, bl, d3, d4, d5, periodicity);
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @Override
    public double getReconBalance() {
        return this.reconBalance;
    }

    @Nullable
    public final Double getFiscalValue() {
        return this.fiscalValue;
    }

    @Nullable
    public final Boolean isSelfOccupied() {
        return this.isSelfOccupied;
    }

    @Nullable
    public final Double getImputedRentalValue() {
        return this.imputedRentalValue;
    }

    @Nullable
    public final Double getRentalIncome() {
        return this.rentalIncome;
    }

    @Nullable
    public final Double getMaintenanceRate() {
        return this.maintenanceRate;
    }

    @NotNull
    public final Periodicity getMaintenancePeriodicity() {
        return this.maintenancePeriodicity;
    }

    @Override
    @NotNull
    public ProductType getProductType() {
        return this.productType;
    }

    @Override
    @NotNull
    public List<PositionCompo> createCompos(@NotNull Portfolio portfolio, @NotNull Position pos) {
        Intrinsics.checkNotNullParameter((Object)portfolio, (String)"portfolio");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        List compos = new ArrayList();
        if (this.maintenanceRate != null && !Intrinsics.areEqual((Double)this.maintenanceRate, (double)0.0)) {
            compos.add(new CashflowCompo(pos, "maintenance", true, ValueProviders.INSTANCE.constValue(this.maintenanceRate / 100.0 * this.getReconBalance()), -1, this.maintenancePeriodicity, null, null, true, 192, null));
        }
        if (this.rentalIncome != null && !Intrinsics.areEqual((Double)this.rentalIncome, (double)0.0)) {
            compos.add(new CashflowCompo(pos, "rentalIncome", true, ValueProviders.INSTANCE.constValue(this.rentalIncome / (double)12), 1, Periodicity.MONTHLY, null, null, false, 448, null));
        }
        return compos;
    }

    @Override
    @NotNull
    public Position createPosition(@NotNull Portfolio portfolio) {
        return Valuable.DefaultImpls.createPosition(this, portfolio);
    }

    @NotNull
    public final String component1() {
        return this.tag;
    }

    public final double component2() {
        return this.reconBalance;
    }

    @Nullable
    public final Double component3() {
        return this.fiscalValue;
    }

    @Nullable
    public final Boolean component4() {
        return this.isSelfOccupied;
    }

    @Nullable
    public final Double component5() {
        return this.imputedRentalValue;
    }

    @Nullable
    public final Double component6() {
        return this.rentalIncome;
    }

    @Nullable
    public final Double component7() {
        return this.maintenanceRate;
    }

    @NotNull
    public final Periodicity component8() {
        return this.maintenancePeriodicity;
    }

    @NotNull
    public final RealEstate copy(@NotNull String tag, double reconBalance, @Nullable Double fiscalValue, @Nullable Boolean isSelfOccupied, @Nullable Double imputedRentalValue, @Nullable Double rentalIncome, @Nullable Double maintenanceRate, @NotNull Periodicity maintenancePeriodicity) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)maintenancePeriodicity), (String)"maintenancePeriodicity");
        return new RealEstate(tag, reconBalance, fiscalValue, isSelfOccupied, imputedRentalValue, rentalIncome, maintenanceRate, maintenancePeriodicity);
    }

    public static /* synthetic */ RealEstate copy$default(RealEstate realEstate, String string, double d, Double d2, Boolean bl, Double d3, Double d4, Double d5, Periodicity periodicity, int n, Object object) {
        if ((n & 1) != 0) {
            string = realEstate.tag;
        }
        if ((n & 2) != 0) {
            d = realEstate.reconBalance;
        }
        if ((n & 4) != 0) {
            d2 = realEstate.fiscalValue;
        }
        if ((n & 8) != 0) {
            bl = realEstate.isSelfOccupied;
        }
        if ((n & 0x10) != 0) {
            d3 = realEstate.imputedRentalValue;
        }
        if ((n & 0x20) != 0) {
            d4 = realEstate.rentalIncome;
        }
        if ((n & 0x40) != 0) {
            d5 = realEstate.maintenanceRate;
        }
        if ((n & 0x80) != 0) {
            periodicity = realEstate.maintenancePeriodicity;
        }
        return realEstate.copy(string, d, d2, bl, d3, d4, d5, periodicity);
    }

    @NotNull
    public String toString() {
        return "RealEstate(tag=" + this.tag + ", reconBalance=" + this.reconBalance + ", fiscalValue=" + this.fiscalValue + ", isSelfOccupied=" + this.isSelfOccupied + ", imputedRentalValue=" + this.imputedRentalValue + ", rentalIncome=" + this.rentalIncome + ", maintenanceRate=" + this.maintenanceRate + ", maintenancePeriodicity=" + this.maintenancePeriodicity + ")";
    }

    public int hashCode() {
        int result = this.tag.hashCode();
        result = result * 31 + Double.hashCode(this.reconBalance);
        result = result * 31 + (this.fiscalValue == null ? 0 : ((Object)this.fiscalValue).hashCode());
        result = result * 31 + (this.isSelfOccupied == null ? 0 : ((Object)this.isSelfOccupied).hashCode());
        result = result * 31 + (this.imputedRentalValue == null ? 0 : ((Object)this.imputedRentalValue).hashCode());
        result = result * 31 + (this.rentalIncome == null ? 0 : ((Object)this.rentalIncome).hashCode());
        result = result * 31 + (this.maintenanceRate == null ? 0 : ((Object)this.maintenanceRate).hashCode());
        result = result * 31 + this.maintenancePeriodicity.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RealEstate)) {
            return false;
        }
        RealEstate realEstate = (RealEstate)other;
        if (!Intrinsics.areEqual((Object)this.tag, (Object)realEstate.tag)) {
            return false;
        }
        if (Double.compare(this.reconBalance, realEstate.reconBalance) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fiscalValue, (Object)realEstate.fiscalValue)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.isSelfOccupied, (Object)realEstate.isSelfOccupied)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.imputedRentalValue, (Object)realEstate.imputedRentalValue)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.rentalIncome, (Object)realEstate.rentalIncome)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.maintenanceRate, (Object)realEstate.maintenanceRate)) {
            return false;
        }
        return this.maintenancePeriodicity == realEstate.maintenancePeriodicity;
    }
}

