/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.household.model.impl;

import io.fincast.household.model.Valuable;
import io.fincast.household.model.enums.ProductType;
import io.fincast.household.model.enums.RevenueAllocation;
import io.fincast.pos.model.Portfolio;
import io.fincast.pos.model.Position;
import io.fincast.pos.model.PositionCompo;
import io.fincast.pos.model.ValueProvider;
import io.fincast.pos.model.ValueProviders;
import io.fincast.pos.model.impl.InterestCompo;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ\t\u0010\u001d\u001a\u00020\tH\u00c6\u0003JD\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001fJ\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u00d6\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001J\t\u0010-\u001a\u00020\u0003H\u00d6\u0001R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006."}, d2={"Lio/fincast/household/model/impl/MoneyAccount;", "Lio/fincast/household/model/Valuable;", "tag", "", "reconBalance", "", "creditInterestRate", "debitInterestRate", "revenueAllocation", "Lio/fincast/household/model/enums/RevenueAllocation;", "(Ljava/lang/String;DLjava/lang/Double;Ljava/lang/Double;Lio/fincast/household/model/enums/RevenueAllocation;)V", "getCreditInterestRate", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getDebitInterestRate", "productType", "Lio/fincast/household/model/enums/ProductType;", "getProductType", "()Lio/fincast/household/model/enums/ProductType;", "getReconBalance", "()D", "getRevenueAllocation", "()Lio/fincast/household/model/enums/RevenueAllocation;", "getTag", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "copy", "(Ljava/lang/String;DLjava/lang/Double;Ljava/lang/Double;Lio/fincast/household/model/enums/RevenueAllocation;)Lio/fincast/household/model/impl/MoneyAccount;", "createCompos", "", "Lio/fincast/pos/model/PositionCompo;", "portfolio", "Lio/fincast/pos/model/Portfolio;", "pos", "Lio/fincast/pos/model/Position;", "equals", "", "other", "", "hashCode", "", "toString", "fincast"})
public final class MoneyAccount
implements Valuable {
    @NotNull
    private final String tag;
    private final double reconBalance;
    @Nullable
    private final Double creditInterestRate;
    @Nullable
    private final Double debitInterestRate;
    @NotNull
    private final RevenueAllocation revenueAllocation;
    @NotNull
    private final ProductType productType;

    public MoneyAccount(@NotNull String tag, double reconBalance, @Nullable Double creditInterestRate, @Nullable Double debitInterestRate, @NotNull RevenueAllocation revenueAllocation) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)revenueAllocation), (String)"revenueAllocation");
        this.tag = tag;
        this.reconBalance = reconBalance;
        this.creditInterestRate = creditInterestRate;
        this.debitInterestRate = debitInterestRate;
        this.revenueAllocation = revenueAllocation;
        this.productType = ProductType.VALUABLE;
    }

    public /* synthetic */ MoneyAccount(String string, double d, Double d2, Double d3, RevenueAllocation revenueAllocation, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 0.0;
        }
        if ((n & 4) != 0) {
            d2 = 0.0;
        }
        if ((n & 8) != 0) {
            d3 = 0.0;
        }
        if ((n & 0x10) != 0) {
            revenueAllocation = RevenueAllocation.REINVESTMENT;
        }
        this(string, d, d2, d3, revenueAllocation);
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @Override
    public double getReconBalance() {
        return this.reconBalance;
    }

    @Nullable
    public final Double getCreditInterestRate() {
        return this.creditInterestRate;
    }

    @Nullable
    public final Double getDebitInterestRate() {
        return this.debitInterestRate;
    }

    @NotNull
    public final RevenueAllocation getRevenueAllocation() {
        return this.revenueAllocation;
    }

    @Override
    @NotNull
    public ProductType getProductType() {
        return this.productType;
    }

    @Override
    @NotNull
    public List<PositionCompo> createCompos(@NotNull Portfolio portfolio, @NotNull Position pos) {
        ValueProvider<Double> valueProvider;
        ValueProvider<Double> valueProvider2;
        RevenueAllocation revenueAllocation;
        Intrinsics.checkNotNullParameter((Object)portfolio, (String)"portfolio");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        List compos = new ArrayList();
        if (this.creditInterestRate != null && !Intrinsics.areEqual((Double)this.creditInterestRate, (double)0.0)) {
            revenueAllocation = this.revenueAllocation;
            valueProvider2 = ValueProviders.INSTANCE.eoyCreditBalance(pos);
            valueProvider = ValueProviders.INSTANCE.constValue(this.creditInterestRate);
            compos.add(new InterestCompo(pos, "creditInterest", valueProvider2, valueProvider, revenueAllocation));
        }
        if (this.debitInterestRate != null && !Intrinsics.areEqual((Double)this.debitInterestRate, (double)0.0)) {
            revenueAllocation = this.revenueAllocation;
            valueProvider2 = ValueProviders.INSTANCE.eoyDebitBalance(pos);
            valueProvider = ValueProviders.INSTANCE.constValue(this.debitInterestRate);
            compos.add(new InterestCompo(pos, "debitInterest", valueProvider2, valueProvider, revenueAllocation));
        }
        return compos;
    }

    @Override
    @NotNull
    public Position createPosition(@NotNull Portfolio portfolio) {
        return Valuable.DefaultImpls.createPosition(this, portfolio);
    }

    @NotNull
    public final String component1() {
        return this.tag;
    }

    public final double component2() {
        return this.reconBalance;
    }

    @Nullable
    public final Double component3() {
        return this.creditInterestRate;
    }

    @Nullable
    public final Double component4() {
        return this.debitInterestRate;
    }

    @NotNull
    public final RevenueAllocation component5() {
        return this.revenueAllocation;
    }

    @NotNull
    public final MoneyAccount copy(@NotNull String tag, double reconBalance, @Nullable Double creditInterestRate, @Nullable Double debitInterestRate, @NotNull RevenueAllocation revenueAllocation) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)revenueAllocation), (String)"revenueAllocation");
        return new MoneyAccount(tag, reconBalance, creditInterestRate, debitInterestRate, revenueAllocation);
    }

    public static /* synthetic */ MoneyAccount copy$default(MoneyAccount moneyAccount, String string, double d, Double d2, Double d3, RevenueAllocation revenueAllocation, int n, Object object) {
        if ((n & 1) != 0) {
            string = moneyAccount.tag;
        }
        if ((n & 2) != 0) {
            d = moneyAccount.reconBalance;
        }
        if ((n & 4) != 0) {
            d2 = moneyAccount.creditInterestRate;
        }
        if ((n & 8) != 0) {
            d3 = moneyAccount.debitInterestRate;
        }
        if ((n & 0x10) != 0) {
            revenueAllocation = moneyAccount.revenueAllocation;
        }
        return moneyAccount.copy(string, d, d2, d3, revenueAllocation);
    }

    @NotNull
    public String toString() {
        return "MoneyAccount(tag=" + this.tag + ", reconBalance=" + this.reconBalance + ", creditInterestRate=" + this.creditInterestRate + ", debitInterestRate=" + this.debitInterestRate + ", revenueAllocation=" + this.revenueAllocation + ")";
    }

    public int hashCode() {
        int result = this.tag.hashCode();
        result = result * 31 + Double.hashCode(this.reconBalance);
        result = result * 31 + (this.creditInterestRate == null ? 0 : ((Object)this.creditInterestRate).hashCode());
        result = result * 31 + (this.debitInterestRate == null ? 0 : ((Object)this.debitInterestRate).hashCode());
        result = result * 31 + this.revenueAllocation.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MoneyAccount)) {
            return false;
        }
        MoneyAccount moneyAccount = (MoneyAccount)other;
        if (!Intrinsics.areEqual((Object)this.tag, (Object)moneyAccount.tag)) {
            return false;
        }
        if (Double.compare(this.reconBalance, moneyAccount.reconBalance) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.creditInterestRate, (Object)moneyAccount.creditInterestRate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.debitInterestRate, (Object)moneyAccount.debitInterestRate)) {
            return false;
        }
        return this.revenueAllocation == moneyAccount.revenueAllocation;
    }
}

