/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.household.model.impl;

import io.fincast.household.model.Valuable;
import io.fincast.household.model.enums.ProductType;
import io.fincast.household.model.enums.RevenueAllocation;
import io.fincast.pos.model.Portfolio;
import io.fincast.pos.model.Position;
import io.fincast.pos.model.PositionCompo;
import io.fincast.pos.model.ValueProvider;
import io.fincast.pos.model.ValueProviders;
import io.fincast.pos.model.impl.InterestCompo;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ.\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0017J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020\u0003H\u00d6\u0001R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006&"}, d2={"Lio/fincast/household/model/impl/Liability;", "Lio/fincast/household/model/Valuable;", "tag", "", "reconBalance", "", "interestRate", "(Ljava/lang/String;DLjava/lang/Double;)V", "getInterestRate", "()Ljava/lang/Double;", "Ljava/lang/Double;", "productType", "Lio/fincast/household/model/enums/ProductType;", "getProductType", "()Lio/fincast/household/model/enums/ProductType;", "getReconBalance", "()D", "getTag", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "(Ljava/lang/String;DLjava/lang/Double;)Lio/fincast/household/model/impl/Liability;", "createCompos", "", "Lio/fincast/pos/model/PositionCompo;", "portfolio", "Lio/fincast/pos/model/Portfolio;", "pos", "Lio/fincast/pos/model/Position;", "equals", "", "other", "", "hashCode", "", "toString", "fincast"})
public final class Liability
implements Valuable {
    @NotNull
    private final String tag;
    private final double reconBalance;
    @Nullable
    private final Double interestRate;
    @NotNull
    private final ProductType productType;

    public Liability(@NotNull String tag, double reconBalance, @Nullable Double interestRate) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.tag = tag;
        this.reconBalance = reconBalance;
        this.interestRate = interestRate;
        this.productType = ProductType.LIABILITY;
    }

    public /* synthetic */ Liability(String string, double d, Double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            d2 = 0.0;
        }
        this(string, d, d2);
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @Override
    public double getReconBalance() {
        return this.reconBalance;
    }

    @Nullable
    public final Double getInterestRate() {
        return this.interestRate;
    }

    @Override
    @NotNull
    public ProductType getProductType() {
        return this.productType;
    }

    @Override
    @NotNull
    public List<PositionCompo> createCompos(@NotNull Portfolio portfolio, @NotNull Position pos) {
        Intrinsics.checkNotNullParameter((Object)portfolio, (String)"portfolio");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        List compos = new ArrayList();
        if (this.interestRate != null && !Intrinsics.areEqual((Double)this.interestRate, (double)0.0)) {
            RevenueAllocation revenueAllocation = RevenueAllocation.PAYOUT;
            ValueProvider<Double> valueProvider = ValueProviders.INSTANCE.eoyBalance(pos);
            ValueProvider<Double> valueProvider2 = ValueProviders.INSTANCE.constValue(this.interestRate);
            compos.add(new InterestCompo(pos, "interest", valueProvider, valueProvider2, revenueAllocation));
        }
        return compos;
    }

    @Override
    @NotNull
    public Position createPosition(@NotNull Portfolio portfolio) {
        return Valuable.DefaultImpls.createPosition(this, portfolio);
    }

    @NotNull
    public final String component1() {
        return this.tag;
    }

    public final double component2() {
        return this.reconBalance;
    }

    @Nullable
    public final Double component3() {
        return this.interestRate;
    }

    @NotNull
    public final Liability copy(@NotNull String tag, double reconBalance, @Nullable Double interestRate) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return new Liability(tag, reconBalance, interestRate);
    }

    public static /* synthetic */ Liability copy$default(Liability liability, String string, double d, Double d2, int n, Object object) {
        if ((n & 1) != 0) {
            string = liability.tag;
        }
        if ((n & 2) != 0) {
            d = liability.reconBalance;
        }
        if ((n & 4) != 0) {
            d2 = liability.interestRate;
        }
        return liability.copy(string, d, d2);
    }

    @NotNull
    public String toString() {
        return "Liability(tag=" + this.tag + ", reconBalance=" + this.reconBalance + ", interestRate=" + this.interestRate + ")";
    }

    public int hashCode() {
        int result = this.tag.hashCode();
        result = result * 31 + Double.hashCode(this.reconBalance);
        result = result * 31 + (this.interestRate == null ? 0 : ((Object)this.interestRate).hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Liability)) {
            return false;
        }
        Liability liability = (Liability)other;
        if (!Intrinsics.areEqual((Object)this.tag, (Object)liability.tag)) {
            return false;
        }
        if (Double.compare(this.reconBalance, liability.reconBalance) != 0) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.interestRate, (Object)liability.interestRate);
    }
}

