/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.household.model.impl;

import io.fincast.household.model.Valuable;
import io.fincast.household.model.enums.ProductType;
import io.fincast.household.model.enums.RevenueAllocation;
import io.fincast.pos.model.Portfolio;
import io.fincast.pos.model.Position;
import io.fincast.pos.model.PositionCompo;
import io.fincast.pos.model.SimDate;
import io.fincast.pos.model.ValueProvider;
import io.fincast.pos.model.ValueProviders;
import io.fincast.pos.model.enums.Periodicity;
import io.fincast.pos.model.impl.CapitalGainCompo;
import io.fincast.pos.model.impl.CashflowCompo;
import io.fincast.pos.model.impl.DividendCompo;
import io.fincast.pos.model.impl.InterestCompo;
import io.fincast.pos.model.impl.TransferCompo;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b%\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u00e5\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\f\u001a\u00020\u0005\u0012\b\b\u0002\u0010\r\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u0012\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u001bJ\t\u0010;\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010<\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010=\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010>\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010?\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001dJ\t\u0010@\u001a\u00020\u0014H\u00c6\u0003J\u0010\u0010A\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010B\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010C\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001dJ\u000b\u0010D\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010E\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\t\u0010F\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010G\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u0010\u0010H\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001dJ\u000b\u0010I\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010J\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010K\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\t\u0010L\u001a\u00020\u0005H\u00c6\u0003J\t\u0010M\u001a\u00020\u0005H\u00c6\u0003J\t\u0010N\u001a\u00020\u0005H\u00c6\u0003J\u00f2\u0001\u0010O\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u00052\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\nH\u00c6\u0001\u00a2\u0006\u0002\u0010PJ\u001e\u0010Q\u001a\b\u0012\u0004\u0012\u00020S0R2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020WH\u0016J\u0013\u0010X\u001a\u00020Y2\b\u0010Z\u001a\u0004\u0018\u00010[H\u00d6\u0003J\t\u0010\\\u001a\u00020]H\u00d6\u0001J\t\u0010^\u001a\u00020\u0003H\u00d6\u0001R\u0015\u0010\u0010\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u001e\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0015\u0010\u000f\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u001e\u001a\u0004\b!\u0010\u001dR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010 R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u001e\u001a\u0004\b#\u0010\u001dR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010%R\u0015\u0010\u0015\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u001e\u001a\u0004\b)\u0010\u001dR\u0015\u0010\u0016\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u001e\u001a\u0004\b*\u0010\u001dR\u0014\u0010+\u001a\u00020,X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010 R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0015\u0010\u0012\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u001e\u001a\u0004\b2\u0010\u001dR\u0015\u0010\u0011\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u001e\u001a\u0004\b3\u0010\u001dR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010 R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0015\u0010\u0017\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u001e\u001a\u0004\b7\u0010\u001dR\u0013\u0010\u001a\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010%R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010'R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010%\u00a8\u0006_"}, d2={"Lio/fincast/household/model/impl/InvestmentAccount;", "Lio/fincast/household/model/Valuable;", "tag", "", "reconBalance", "", "contributionAmount", "contributionPeriodicity", "Lio/fincast/pos/model/enums/Periodicity;", "contributionStartDate", "Lio/fincast/pos/model/SimDate;", "contributionEndDate", "cashPart", "bondPart", "stockPart", "cashInterestRate", "bondInterestRate", "stockDividendYield", "stockCapitalGain", "revenueAllocation", "Lio/fincast/household/model/enums/RevenueAllocation;", "managementFee", "performanceFee", "withdrawalAmount", "withdrawalPeriodicity", "withdrawalStartDate", "withdrawalEndDate", "(Ljava/lang/String;DLjava/lang/Double;Lio/fincast/pos/model/enums/Periodicity;Lio/fincast/pos/model/SimDate;Lio/fincast/pos/model/SimDate;DDDLjava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;Lio/fincast/household/model/enums/RevenueAllocation;Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;Lio/fincast/pos/model/enums/Periodicity;Lio/fincast/pos/model/SimDate;Lio/fincast/pos/model/SimDate;)V", "getBondInterestRate", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getBondPart", "()D", "getCashInterestRate", "getCashPart", "getContributionAmount", "getContributionEndDate", "()Lio/fincast/pos/model/SimDate;", "getContributionPeriodicity", "()Lio/fincast/pos/model/enums/Periodicity;", "getContributionStartDate", "getManagementFee", "getPerformanceFee", "productType", "Lio/fincast/household/model/enums/ProductType;", "getProductType", "()Lio/fincast/household/model/enums/ProductType;", "getReconBalance", "getRevenueAllocation", "()Lio/fincast/household/model/enums/RevenueAllocation;", "getStockCapitalGain", "getStockDividendYield", "getStockPart", "getTag", "()Ljava/lang/String;", "getWithdrawalAmount", "getWithdrawalEndDate", "getWithdrawalPeriodicity", "getWithdrawalStartDate", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component19", "component2", "component20", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/lang/String;DLjava/lang/Double;Lio/fincast/pos/model/enums/Periodicity;Lio/fincast/pos/model/SimDate;Lio/fincast/pos/model/SimDate;DDDLjava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;Lio/fincast/household/model/enums/RevenueAllocation;Ljava/lang/Double;Ljava/lang/Double;Ljava/lang/Double;Lio/fincast/pos/model/enums/Periodicity;Lio/fincast/pos/model/SimDate;Lio/fincast/pos/model/SimDate;)Lio/fincast/household/model/impl/InvestmentAccount;", "createCompos", "", "Lio/fincast/pos/model/PositionCompo;", "portfolio", "Lio/fincast/pos/model/Portfolio;", "pos", "Lio/fincast/pos/model/Position;", "equals", "", "other", "", "hashCode", "", "toString", "fincast"})
public final class InvestmentAccount
implements Valuable {
    @NotNull
    private final String tag;
    private final double reconBalance;
    @Nullable
    private final Double contributionAmount;
    @Nullable
    private final Periodicity contributionPeriodicity;
    @Nullable
    private final SimDate contributionStartDate;
    @Nullable
    private final SimDate contributionEndDate;
    private final double cashPart;
    private final double bondPart;
    private final double stockPart;
    @Nullable
    private final Double cashInterestRate;
    @Nullable
    private final Double bondInterestRate;
    @Nullable
    private final Double stockDividendYield;
    @Nullable
    private final Double stockCapitalGain;
    @NotNull
    private final RevenueAllocation revenueAllocation;
    @Nullable
    private final Double managementFee;
    @Nullable
    private final Double performanceFee;
    @Nullable
    private final Double withdrawalAmount;
    @Nullable
    private final Periodicity withdrawalPeriodicity;
    @Nullable
    private final SimDate withdrawalStartDate;
    @Nullable
    private final SimDate withdrawalEndDate;
    @NotNull
    private final ProductType productType;

    public InvestmentAccount(@NotNull String tag, double reconBalance, @Nullable Double contributionAmount, @Nullable Periodicity contributionPeriodicity, @Nullable SimDate contributionStartDate, @Nullable SimDate contributionEndDate, double cashPart, double bondPart, double stockPart, @Nullable Double cashInterestRate, @Nullable Double bondInterestRate, @Nullable Double stockDividendYield, @Nullable Double stockCapitalGain, @NotNull RevenueAllocation revenueAllocation, @Nullable Double managementFee, @Nullable Double performanceFee, @Nullable Double withdrawalAmount, @Nullable Periodicity withdrawalPeriodicity, @Nullable SimDate withdrawalStartDate, @Nullable SimDate withdrawalEndDate) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)revenueAllocation), (String)"revenueAllocation");
        this.tag = tag;
        this.reconBalance = reconBalance;
        this.contributionAmount = contributionAmount;
        this.contributionPeriodicity = contributionPeriodicity;
        this.contributionStartDate = contributionStartDate;
        this.contributionEndDate = contributionEndDate;
        this.cashPart = cashPart;
        this.bondPart = bondPart;
        this.stockPart = stockPart;
        this.cashInterestRate = cashInterestRate;
        this.bondInterestRate = bondInterestRate;
        this.stockDividendYield = stockDividendYield;
        this.stockCapitalGain = stockCapitalGain;
        this.revenueAllocation = revenueAllocation;
        this.managementFee = managementFee;
        this.performanceFee = performanceFee;
        this.withdrawalAmount = withdrawalAmount;
        this.withdrawalPeriodicity = withdrawalPeriodicity;
        this.withdrawalStartDate = withdrawalStartDate;
        this.withdrawalEndDate = withdrawalEndDate;
        this.productType = ProductType.ASSET;
    }

    public /* synthetic */ InvestmentAccount(String string, double d, Double d2, Periodicity periodicity, SimDate simDate, SimDate simDate2, double d3, double d4, double d5, Double d6, Double d7, Double d8, Double d9, RevenueAllocation revenueAllocation, Double d10, Double d11, Double d12, Periodicity periodicity2, SimDate simDate3, SimDate simDate4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            d2 = null;
        }
        if ((n & 8) != 0) {
            periodicity = null;
        }
        if ((n & 0x10) != 0) {
            simDate = null;
        }
        if ((n & 0x20) != 0) {
            simDate2 = null;
        }
        if ((n & 0x40) != 0) {
            d3 = 0.0;
        }
        if ((n & 0x80) != 0) {
            d4 = 0.0;
        }
        if ((n & 0x100) != 0) {
            d5 = 0.0;
        }
        if ((n & 0x200) != 0) {
            d6 = null;
        }
        if ((n & 0x400) != 0) {
            d7 = null;
        }
        if ((n & 0x800) != 0) {
            d8 = null;
        }
        if ((n & 0x1000) != 0) {
            d9 = null;
        }
        if ((n & 0x2000) != 0) {
            revenueAllocation = RevenueAllocation.PAYOUT;
        }
        if ((n & 0x4000) != 0) {
            d10 = 0.0;
        }
        if ((n & 0x8000) != 0) {
            d11 = 0.0;
        }
        if ((n & 0x10000) != 0) {
            d12 = null;
        }
        if ((n & 0x20000) != 0) {
            periodicity2 = null;
        }
        if ((n & 0x40000) != 0) {
            simDate3 = null;
        }
        if ((n & 0x80000) != 0) {
            simDate4 = null;
        }
        this(string, d, d2, periodicity, simDate, simDate2, d3, d4, d5, d6, d7, d8, d9, revenueAllocation, d10, d11, d12, periodicity2, simDate3, simDate4);
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @Override
    public double getReconBalance() {
        return this.reconBalance;
    }

    @Nullable
    public final Double getContributionAmount() {
        return this.contributionAmount;
    }

    @Nullable
    public final Periodicity getContributionPeriodicity() {
        return this.contributionPeriodicity;
    }

    @Nullable
    public final SimDate getContributionStartDate() {
        return this.contributionStartDate;
    }

    @Nullable
    public final SimDate getContributionEndDate() {
        return this.contributionEndDate;
    }

    public final double getCashPart() {
        return this.cashPart;
    }

    public final double getBondPart() {
        return this.bondPart;
    }

    public final double getStockPart() {
        return this.stockPart;
    }

    @Nullable
    public final Double getCashInterestRate() {
        return this.cashInterestRate;
    }

    @Nullable
    public final Double getBondInterestRate() {
        return this.bondInterestRate;
    }

    @Nullable
    public final Double getStockDividendYield() {
        return this.stockDividendYield;
    }

    @Nullable
    public final Double getStockCapitalGain() {
        return this.stockCapitalGain;
    }

    @NotNull
    public final RevenueAllocation getRevenueAllocation() {
        return this.revenueAllocation;
    }

    @Nullable
    public final Double getManagementFee() {
        return this.managementFee;
    }

    @Nullable
    public final Double getPerformanceFee() {
        return this.performanceFee;
    }

    @Nullable
    public final Double getWithdrawalAmount() {
        return this.withdrawalAmount;
    }

    @Nullable
    public final Periodicity getWithdrawalPeriodicity() {
        return this.withdrawalPeriodicity;
    }

    @Nullable
    public final SimDate getWithdrawalStartDate() {
        return this.withdrawalStartDate;
    }

    @Nullable
    public final SimDate getWithdrawalEndDate() {
        return this.withdrawalEndDate;
    }

    @Override
    @NotNull
    public ProductType getProductType() {
        return this.productType;
    }

    @Override
    @NotNull
    public List<PositionCompo> createCompos(@NotNull Portfolio portfolio, @NotNull Position pos) {
        Periodicity periodicity;
        SimDate simDate;
        ValueProvider<Double> valueProvider;
        Object object;
        Object startDate;
        Intrinsics.checkNotNullParameter((Object)portfolio, (String)"portfolio");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        List compos = new ArrayList();
        if (this.contributionAmount != null && this.contributionAmount > 0.0) {
            SimDate simDate2 = this.contributionStartDate;
            if (simDate2 == null) {
                simDate2 = portfolio.getReconDate();
            }
            startDate = SimDate.Companion.max(simDate2, portfolio.getReconDate());
            object = portfolio.getPocketMoney();
            valueProvider = ValueProviders.INSTANCE.constValue(this.contributionAmount);
            simDate = this.contributionEndDate;
            Periodicity periodicity2 = this.contributionPeriodicity;
            if (periodicity2 == null) {
                periodicity2 = Periodicity.YEARLY;
            }
            periodicity = periodicity2;
            compos.add(new TransferCompo(pos, "contribution", (Position)object, pos, valueProvider, -1, periodicity, (SimDate)startDate, simDate));
        }
        if (!(this.cashPart == 0.0) && this.cashInterestRate != null && !Intrinsics.areEqual((Double)this.cashInterestRate, (double)0.0)) {
            startDate = this.revenueAllocation;
            object = ValueProviders.INSTANCE.eoyBalance(pos);
            valueProvider = ValueProviders.INSTANCE.constValue(this.cashPart / 100.0 * this.cashInterestRate);
            compos.add(new InterestCompo(pos, "cashInterest", (ValueProvider<Double>)object, valueProvider, (RevenueAllocation)((Object)startDate)));
        }
        if (!(this.bondPart == 0.0) && this.bondInterestRate != null && !Intrinsics.areEqual((Double)this.bondInterestRate, (double)0.0)) {
            startDate = this.revenueAllocation;
            object = ValueProviders.INSTANCE.eoyBalance(pos);
            valueProvider = ValueProviders.INSTANCE.constValue(this.bondPart / 100.0 * this.bondInterestRate);
            compos.add(new InterestCompo(pos, "bondInterest", (ValueProvider<Double>)object, valueProvider, (RevenueAllocation)((Object)startDate)));
        }
        if (!(this.stockPart == 0.0)) {
            if (this.stockDividendYield != null && !Intrinsics.areEqual((Double)this.stockDividendYield, (double)0.0)) {
                compos.add(new DividendCompo(pos, "dividend", this.revenueAllocation, ValueProviders.INSTANCE.constValue(this.stockPart / 100.0 * this.stockDividendYield)));
            }
            if (this.stockCapitalGain != null && !Intrinsics.areEqual((Double)this.stockCapitalGain, (double)0.0)) {
                compos.add(new CapitalGainCompo(pos, "capitalGain", ValueProviders.INSTANCE.constValue(this.stockPart / 100.0 * this.stockCapitalGain)));
            }
        }
        if (this.managementFee != null && !Intrinsics.areEqual((Double)this.managementFee, (double)0.0)) {
            compos.add(new CashflowCompo(pos, "managementFee", false, arg_0 -> InvestmentAccount.createCompos$lambda$0(this, pos, arg_0), -1, Periodicity.YEARLY, null, null, false, 448, null));
        }
        if (this.performanceFee != null && !Intrinsics.areEqual((Double)this.performanceFee, (double)0.0)) {
            compos.add(new CashflowCompo(pos, "performanceFee", false, arg_0 -> InvestmentAccount.createCompos$lambda$1(this, pos, arg_0), -1, Periodicity.YEARLY, null, null, false, 448, null));
        }
        if (this.withdrawalAmount != null && this.withdrawalAmount > 0.0) {
            SimDate simDate3 = this.withdrawalStartDate;
            if (simDate3 == null) {
                simDate3 = portfolio.getReconDate();
            }
            startDate = SimDate.Companion.max(simDate3, portfolio.getReconDate());
            object = portfolio.getPocketMoney();
            valueProvider = ValueProviders.INSTANCE.constValue(this.withdrawalAmount);
            simDate = this.withdrawalEndDate;
            Periodicity periodicity3 = this.withdrawalPeriodicity;
            if (periodicity3 == null) {
                periodicity3 = Periodicity.YEARLY;
            }
            periodicity = periodicity3;
            compos.add(new TransferCompo(pos, "withdrawal", pos, (Position)object, valueProvider, -1, periodicity, (SimDate)startDate, simDate));
        }
        return compos;
    }

    @Override
    @NotNull
    public Position createPosition(@NotNull Portfolio portfolio) {
        return Valuable.DefaultImpls.createPosition(this, portfolio);
    }

    @NotNull
    public final String component1() {
        return this.tag;
    }

    public final double component2() {
        return this.reconBalance;
    }

    @Nullable
    public final Double component3() {
        return this.contributionAmount;
    }

    @Nullable
    public final Periodicity component4() {
        return this.contributionPeriodicity;
    }

    @Nullable
    public final SimDate component5() {
        return this.contributionStartDate;
    }

    @Nullable
    public final SimDate component6() {
        return this.contributionEndDate;
    }

    public final double component7() {
        return this.cashPart;
    }

    public final double component8() {
        return this.bondPart;
    }

    public final double component9() {
        return this.stockPart;
    }

    @Nullable
    public final Double component10() {
        return this.cashInterestRate;
    }

    @Nullable
    public final Double component11() {
        return this.bondInterestRate;
    }

    @Nullable
    public final Double component12() {
        return this.stockDividendYield;
    }

    @Nullable
    public final Double component13() {
        return this.stockCapitalGain;
    }

    @NotNull
    public final RevenueAllocation component14() {
        return this.revenueAllocation;
    }

    @Nullable
    public final Double component15() {
        return this.managementFee;
    }

    @Nullable
    public final Double component16() {
        return this.performanceFee;
    }

    @Nullable
    public final Double component17() {
        return this.withdrawalAmount;
    }

    @Nullable
    public final Periodicity component18() {
        return this.withdrawalPeriodicity;
    }

    @Nullable
    public final SimDate component19() {
        return this.withdrawalStartDate;
    }

    @Nullable
    public final SimDate component20() {
        return this.withdrawalEndDate;
    }

    @NotNull
    public final InvestmentAccount copy(@NotNull String tag, double reconBalance, @Nullable Double contributionAmount, @Nullable Periodicity contributionPeriodicity, @Nullable SimDate contributionStartDate, @Nullable SimDate contributionEndDate, double cashPart, double bondPart, double stockPart, @Nullable Double cashInterestRate, @Nullable Double bondInterestRate, @Nullable Double stockDividendYield, @Nullable Double stockCapitalGain, @NotNull RevenueAllocation revenueAllocation, @Nullable Double managementFee, @Nullable Double performanceFee, @Nullable Double withdrawalAmount, @Nullable Periodicity withdrawalPeriodicity, @Nullable SimDate withdrawalStartDate, @Nullable SimDate withdrawalEndDate) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)((Object)revenueAllocation), (String)"revenueAllocation");
        return new InvestmentAccount(tag, reconBalance, contributionAmount, contributionPeriodicity, contributionStartDate, contributionEndDate, cashPart, bondPart, stockPart, cashInterestRate, bondInterestRate, stockDividendYield, stockCapitalGain, revenueAllocation, managementFee, performanceFee, withdrawalAmount, withdrawalPeriodicity, withdrawalStartDate, withdrawalEndDate);
    }

    public static /* synthetic */ InvestmentAccount copy$default(InvestmentAccount investmentAccount, String string, double d, Double d2, Periodicity periodicity, SimDate simDate, SimDate simDate2, double d3, double d4, double d5, Double d6, Double d7, Double d8, Double d9, RevenueAllocation revenueAllocation, Double d10, Double d11, Double d12, Periodicity periodicity2, SimDate simDate3, SimDate simDate4, int n, Object object) {
        if ((n & 1) != 0) {
            string = investmentAccount.tag;
        }
        if ((n & 2) != 0) {
            d = investmentAccount.reconBalance;
        }
        if ((n & 4) != 0) {
            d2 = investmentAccount.contributionAmount;
        }
        if ((n & 8) != 0) {
            periodicity = investmentAccount.contributionPeriodicity;
        }
        if ((n & 0x10) != 0) {
            simDate = investmentAccount.contributionStartDate;
        }
        if ((n & 0x20) != 0) {
            simDate2 = investmentAccount.contributionEndDate;
        }
        if ((n & 0x40) != 0) {
            d3 = investmentAccount.cashPart;
        }
        if ((n & 0x80) != 0) {
            d4 = investmentAccount.bondPart;
        }
        if ((n & 0x100) != 0) {
            d5 = investmentAccount.stockPart;
        }
        if ((n & 0x200) != 0) {
            d6 = investmentAccount.cashInterestRate;
        }
        if ((n & 0x400) != 0) {
            d7 = investmentAccount.bondInterestRate;
        }
        if ((n & 0x800) != 0) {
            d8 = investmentAccount.stockDividendYield;
        }
        if ((n & 0x1000) != 0) {
            d9 = investmentAccount.stockCapitalGain;
        }
        if ((n & 0x2000) != 0) {
            revenueAllocation = investmentAccount.revenueAllocation;
        }
        if ((n & 0x4000) != 0) {
            d10 = investmentAccount.managementFee;
        }
        if ((n & 0x8000) != 0) {
            d11 = investmentAccount.performanceFee;
        }
        if ((n & 0x10000) != 0) {
            d12 = investmentAccount.withdrawalAmount;
        }
        if ((n & 0x20000) != 0) {
            periodicity2 = investmentAccount.withdrawalPeriodicity;
        }
        if ((n & 0x40000) != 0) {
            simDate3 = investmentAccount.withdrawalStartDate;
        }
        if ((n & 0x80000) != 0) {
            simDate4 = investmentAccount.withdrawalEndDate;
        }
        return investmentAccount.copy(string, d, d2, periodicity, simDate, simDate2, d3, d4, d5, d6, d7, d8, d9, revenueAllocation, d10, d11, d12, periodicity2, simDate3, simDate4);
    }

    @NotNull
    public String toString() {
        return "InvestmentAccount(tag=" + this.tag + ", reconBalance=" + this.reconBalance + ", contributionAmount=" + this.contributionAmount + ", contributionPeriodicity=" + this.contributionPeriodicity + ", contributionStartDate=" + this.contributionStartDate + ", contributionEndDate=" + this.contributionEndDate + ", cashPart=" + this.cashPart + ", bondPart=" + this.bondPart + ", stockPart=" + this.stockPart + ", cashInterestRate=" + this.cashInterestRate + ", bondInterestRate=" + this.bondInterestRate + ", stockDividendYield=" + this.stockDividendYield + ", stockCapitalGain=" + this.stockCapitalGain + ", revenueAllocation=" + this.revenueAllocation + ", managementFee=" + this.managementFee + ", performanceFee=" + this.performanceFee + ", withdrawalAmount=" + this.withdrawalAmount + ", withdrawalPeriodicity=" + this.withdrawalPeriodicity + ", withdrawalStartDate=" + this.withdrawalStartDate + ", withdrawalEndDate=" + this.withdrawalEndDate + ")";
    }

    public int hashCode() {
        int result = this.tag.hashCode();
        result = result * 31 + Double.hashCode(this.reconBalance);
        result = result * 31 + (this.contributionAmount == null ? 0 : ((Object)this.contributionAmount).hashCode());
        result = result * 31 + (this.contributionPeriodicity == null ? 0 : this.contributionPeriodicity.hashCode());
        result = result * 31 + (this.contributionStartDate == null ? 0 : this.contributionStartDate.hashCode());
        result = result * 31 + (this.contributionEndDate == null ? 0 : this.contributionEndDate.hashCode());
        result = result * 31 + Double.hashCode(this.cashPart);
        result = result * 31 + Double.hashCode(this.bondPart);
        result = result * 31 + Double.hashCode(this.stockPart);
        result = result * 31 + (this.cashInterestRate == null ? 0 : ((Object)this.cashInterestRate).hashCode());
        result = result * 31 + (this.bondInterestRate == null ? 0 : ((Object)this.bondInterestRate).hashCode());
        result = result * 31 + (this.stockDividendYield == null ? 0 : ((Object)this.stockDividendYield).hashCode());
        result = result * 31 + (this.stockCapitalGain == null ? 0 : ((Object)this.stockCapitalGain).hashCode());
        result = result * 31 + this.revenueAllocation.hashCode();
        result = result * 31 + (this.managementFee == null ? 0 : ((Object)this.managementFee).hashCode());
        result = result * 31 + (this.performanceFee == null ? 0 : ((Object)this.performanceFee).hashCode());
        result = result * 31 + (this.withdrawalAmount == null ? 0 : ((Object)this.withdrawalAmount).hashCode());
        result = result * 31 + (this.withdrawalPeriodicity == null ? 0 : this.withdrawalPeriodicity.hashCode());
        result = result * 31 + (this.withdrawalStartDate == null ? 0 : this.withdrawalStartDate.hashCode());
        result = result * 31 + (this.withdrawalEndDate == null ? 0 : this.withdrawalEndDate.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InvestmentAccount)) {
            return false;
        }
        InvestmentAccount investmentAccount = (InvestmentAccount)other;
        if (!Intrinsics.areEqual((Object)this.tag, (Object)investmentAccount.tag)) {
            return false;
        }
        if (Double.compare(this.reconBalance, investmentAccount.reconBalance) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.contributionAmount, (Object)investmentAccount.contributionAmount)) {
            return false;
        }
        if (this.contributionPeriodicity != investmentAccount.contributionPeriodicity) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.contributionStartDate, (Object)investmentAccount.contributionStartDate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.contributionEndDate, (Object)investmentAccount.contributionEndDate)) {
            return false;
        }
        if (Double.compare(this.cashPart, investmentAccount.cashPart) != 0) {
            return false;
        }
        if (Double.compare(this.bondPart, investmentAccount.bondPart) != 0) {
            return false;
        }
        if (Double.compare(this.stockPart, investmentAccount.stockPart) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.cashInterestRate, (Object)investmentAccount.cashInterestRate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.bondInterestRate, (Object)investmentAccount.bondInterestRate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.stockDividendYield, (Object)investmentAccount.stockDividendYield)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.stockCapitalGain, (Object)investmentAccount.stockCapitalGain)) {
            return false;
        }
        if (this.revenueAllocation != investmentAccount.revenueAllocation) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.managementFee, (Object)investmentAccount.managementFee)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.performanceFee, (Object)investmentAccount.performanceFee)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.withdrawalAmount, (Object)investmentAccount.withdrawalAmount)) {
            return false;
        }
        if (this.withdrawalPeriodicity != investmentAccount.withdrawalPeriodicity) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.withdrawalStartDate, (Object)investmentAccount.withdrawalStartDate)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.withdrawalEndDate, (Object)investmentAccount.withdrawalEndDate);
    }

    private static final double createCompos$lambda$0(InvestmentAccount this$0, Position $pos, SimDate it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$pos, (String)"$pos");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.managementFee / (double)100 * $pos.getBalance(it);
    }

    private static final double createCompos$lambda$1(InvestmentAccount this$0, Position $pos, SimDate it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$pos, (String)"$pos");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.performanceFee / (double)100 * ($pos.getBalance(it) - $pos.getBalance(it.addYears(-1)));
    }
}

