/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.household.model.impl;

import io.fincast.household.model.Contract;
import io.fincast.household.model.enums.ProductType;
import io.fincast.pos.model.Portfolio;
import io.fincast.pos.model.Position;
import io.fincast.pos.model.PositionCompo;
import io.fincast.pos.model.SimDate;
import io.fincast.pos.model.ValueProvider;
import io.fincast.pos.model.enums.Periodicity;
import io.fincast.pos.model.impl.CashflowCompo;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\fJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\nH\u00c6\u0003JG\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u00d6\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001J\t\u0010-\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006."}, d2={"Lio/fincast/household/model/impl/Income;", "Lio/fincast/household/model/Contract;", "tag", "", "amount", "Lio/fincast/pos/model/ValueProvider;", "", "periodicity", "Lio/fincast/pos/model/enums/Periodicity;", "startDate", "Lio/fincast/pos/model/SimDate;", "endDate", "(Ljava/lang/String;Lio/fincast/pos/model/ValueProvider;Lio/fincast/pos/model/enums/Periodicity;Lio/fincast/pos/model/SimDate;Lio/fincast/pos/model/SimDate;)V", "getAmount", "()Lio/fincast/pos/model/ValueProvider;", "getEndDate", "()Lio/fincast/pos/model/SimDate;", "getPeriodicity", "()Lio/fincast/pos/model/enums/Periodicity;", "productType", "Lio/fincast/household/model/enums/ProductType;", "getProductType", "()Lio/fincast/household/model/enums/ProductType;", "getStartDate", "getTag", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "copy", "createCompos", "", "Lio/fincast/pos/model/PositionCompo;", "portfolio", "Lio/fincast/pos/model/Portfolio;", "pos", "Lio/fincast/pos/model/Position;", "equals", "", "other", "", "hashCode", "", "toString", "fincast"})
public final class Income
implements Contract {
    @NotNull
    private final String tag;
    @NotNull
    private final ValueProvider<Double> amount;
    @Nullable
    private final Periodicity periodicity;
    @Nullable
    private final SimDate startDate;
    @Nullable
    private final SimDate endDate;
    @NotNull
    private final ProductType productType;

    public Income(@NotNull String tag, @NotNull ValueProvider<Double> amount, @Nullable Periodicity periodicity, @Nullable SimDate startDate, @Nullable SimDate endDate) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        this.tag = tag;
        this.amount = amount;
        this.periodicity = periodicity;
        this.startDate = startDate;
        this.endDate = endDate;
        this.productType = ProductType.INCOME;
    }

    public /* synthetic */ Income(String string, ValueProvider valueProvider, Periodicity periodicity, SimDate simDate, SimDate simDate2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            periodicity = Periodicity.YEARLY;
        }
        if ((n & 8) != 0) {
            simDate = null;
        }
        if ((n & 0x10) != 0) {
            simDate2 = null;
        }
        this(string, valueProvider, periodicity, simDate, simDate2);
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @NotNull
    public final ValueProvider<Double> getAmount() {
        return this.amount;
    }

    @Nullable
    public final Periodicity getPeriodicity() {
        return this.periodicity;
    }

    @Override
    @Nullable
    public SimDate getStartDate() {
        return this.startDate;
    }

    @Override
    @Nullable
    public SimDate getEndDate() {
        return this.endDate;
    }

    @Override
    @NotNull
    public ProductType getProductType() {
        return this.productType;
    }

    @Override
    @NotNull
    public List<PositionCompo> createCompos(@NotNull Portfolio portfolio, @NotNull Position pos) {
        Intrinsics.checkNotNullParameter((Object)portfolio, (String)"portfolio");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        SimDate simDate = this.getStartDate();
        if (simDate == null) {
            simDate = portfolio.getReconDate();
        }
        SimDate startDate = SimDate.Companion.max(simDate, portfolio.getReconDate());
        ValueProvider<Double> valueProvider = this.amount;
        SimDate simDate2 = this.getEndDate();
        Periodicity periodicity = this.periodicity;
        if (periodicity == null) {
            periodicity = Periodicity.YEARLY;
        }
        Periodicity periodicity2 = periodicity;
        CashflowCompo cf = new CashflowCompo(pos, "income", true, valueProvider, 1, periodicity2, startDate, simDate2, true);
        return CollectionsKt.listOf((Object)cf);
    }

    @Override
    @NotNull
    public Position createPosition(@NotNull Portfolio portfolio) {
        return Contract.DefaultImpls.createPosition(this, portfolio);
    }

    @NotNull
    public final String component1() {
        return this.tag;
    }

    @NotNull
    public final ValueProvider<Double> component2() {
        return this.amount;
    }

    @Nullable
    public final Periodicity component3() {
        return this.periodicity;
    }

    @Nullable
    public final SimDate component4() {
        return this.startDate;
    }

    @Nullable
    public final SimDate component5() {
        return this.endDate;
    }

    @NotNull
    public final Income copy(@NotNull String tag, @NotNull ValueProvider<Double> amount, @Nullable Periodicity periodicity, @Nullable SimDate startDate, @Nullable SimDate endDate) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter(amount, (String)"amount");
        return new Income(tag, amount, periodicity, startDate, endDate);
    }

    public static /* synthetic */ Income copy$default(Income income, String string, ValueProvider valueProvider, Periodicity periodicity, SimDate simDate, SimDate simDate2, int n, Object object) {
        if ((n & 1) != 0) {
            string = income.tag;
        }
        if ((n & 2) != 0) {
            valueProvider = income.amount;
        }
        if ((n & 4) != 0) {
            periodicity = income.periodicity;
        }
        if ((n & 8) != 0) {
            simDate = income.startDate;
        }
        if ((n & 0x10) != 0) {
            simDate2 = income.endDate;
        }
        return income.copy(string, valueProvider, periodicity, simDate, simDate2);
    }

    @NotNull
    public String toString() {
        return "Income(tag=" + this.tag + ", amount=" + this.amount + ", periodicity=" + this.periodicity + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ")";
    }

    public int hashCode() {
        int result = this.tag.hashCode();
        result = result * 31 + this.amount.hashCode();
        result = result * 31 + (this.periodicity == null ? 0 : this.periodicity.hashCode());
        result = result * 31 + (this.startDate == null ? 0 : this.startDate.hashCode());
        result = result * 31 + (this.endDate == null ? 0 : this.endDate.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Income)) {
            return false;
        }
        Income income = (Income)other;
        if (!Intrinsics.areEqual((Object)this.tag, (Object)income.tag)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.amount, income.amount)) {
            return false;
        }
        if (this.periodicity != income.periodicity) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.startDate, (Object)income.startDate)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.endDate, (Object)income.endDate);
    }
}

