/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.household.model.impl;

import io.fincast.household.model.Holding;
import io.fincast.household.model.Household;
import io.fincast.household.model.Person;
import io.fincast.pos.model.Portfolio;
import io.fincast.pos.model.PortfolioKt;
import io.fincast.pos.model.Position;
import io.fincast.pos.model.SimDate;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lio/fincast/household/model/impl/HouseholdImpl;", "Lio/fincast/household/model/Household;", "persons", "", "Lio/fincast/household/model/Person;", "reconDate", "Lio/fincast/pos/model/SimDate;", "holdings", "Lio/fincast/household/model/Holding;", "(Ljava/util/List;Lio/fincast/pos/model/SimDate;Ljava/util/List;)V", "getHoldings", "()Ljava/util/List;", "getPersons", "getReconDate", "()Lio/fincast/pos/model/SimDate;", "calcProjection", "Lio/fincast/pos/model/Portfolio;", "endDate", "fincast"})
@SourceDebugExtension(value={"SMAP\nHouseholdImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HouseholdImpl.kt\nio/fincast/household/model/impl/HouseholdImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1855#2,2:65\n1855#2,2:67\n*S KotlinDebug\n*F\n+ 1 HouseholdImpl.kt\nio/fincast/household/model/impl/HouseholdImpl\n*L\n26#1:65,2\n29#1:67,2\n*E\n"})
public final class HouseholdImpl
implements Household {
    @NotNull
    private final List<Person> persons;
    @NotNull
    private final SimDate reconDate;
    @NotNull
    private final List<Holding> holdings;

    public HouseholdImpl(@NotNull List<? extends Person> persons, @NotNull SimDate reconDate, @NotNull List<? extends Holding> holdings) {
        Intrinsics.checkNotNullParameter(persons, (String)"persons");
        Intrinsics.checkNotNullParameter((Object)reconDate, (String)"reconDate");
        Intrinsics.checkNotNullParameter(holdings, (String)"holdings");
        this.persons = persons;
        this.reconDate = reconDate;
        this.holdings = holdings;
    }

    @Override
    @NotNull
    public List<Person> getPersons() {
        return this.persons;
    }

    @Override
    @NotNull
    public SimDate getReconDate() {
        return this.reconDate;
    }

    @Override
    @NotNull
    public List<Holding> getHoldings() {
        return this.holdings;
    }

    @Override
    @NotNull
    public Portfolio calcProjection(@NotNull SimDate endDate) {
        Intrinsics.checkNotNullParameter((Object)endDate, (String)"endDate");
        Portfolio portfolio = PortfolioKt.createPortfolio(this.getReconDate(), this.getHoldings());
        for (SimDate d : this.getReconDate().plus(1).rangeTo(endDate)) {
            Position it;
            Iterable $this$forEach$iv = portfolio.getPositions();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Position)element$iv;
                boolean bl = false;
                it.handlePositionLifecycle(d);
            }
            $this$forEach$iv = portfolio.getPositions();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Position)element$iv;
                boolean bl = false;
                it.handlePortfolioLifecycle(d);
            }
        }
        return portfolio;
    }
}

