/*
 * Decompiled with CFR 0.152.
 */
package io.fincast.household.model.impl;

import io.fincast.household.model.Valuable;
import io.fincast.household.model.enums.ProductType;
import io.fincast.household.model.enums.RevenueAllocation;
import io.fincast.pos.model.Portfolio;
import io.fincast.pos.model.Position;
import io.fincast.pos.model.PositionCompo;
import io.fincast.pos.model.ValueProvider;
import io.fincast.pos.model.ValueProviders;
import io.fincast.pos.model.enums.Periodicity;
import io.fincast.pos.model.impl.CashflowCompo;
import io.fincast.pos.model.impl.InterestCompo;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\u000b\u0010\u001d\u001a\u0004\u0018\u00010\tH\u00c6\u0003JF\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001fJ\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u00d6\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001J\t\u0010-\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006."}, d2={"Lio/fincast/household/model/impl/Asset;", "Lio/fincast/household/model/Valuable;", "tag", "", "reconBalance", "", "interestRate", "insuranceRate", "insurancePeriodicity", "Lio/fincast/pos/model/enums/Periodicity;", "(Ljava/lang/String;DLjava/lang/Double;Ljava/lang/Double;Lio/fincast/pos/model/enums/Periodicity;)V", "getInsurancePeriodicity", "()Lio/fincast/pos/model/enums/Periodicity;", "getInsuranceRate", "()Ljava/lang/Double;", "Ljava/lang/Double;", "getInterestRate", "productType", "Lio/fincast/household/model/enums/ProductType;", "getProductType", "()Lio/fincast/household/model/enums/ProductType;", "getReconBalance", "()D", "getTag", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "copy", "(Ljava/lang/String;DLjava/lang/Double;Ljava/lang/Double;Lio/fincast/pos/model/enums/Periodicity;)Lio/fincast/household/model/impl/Asset;", "createCompos", "", "Lio/fincast/pos/model/PositionCompo;", "portfolio", "Lio/fincast/pos/model/Portfolio;", "pos", "Lio/fincast/pos/model/Position;", "equals", "", "other", "", "hashCode", "", "toString", "fincast"})
public final class Asset
implements Valuable {
    @NotNull
    private final String tag;
    private final double reconBalance;
    @Nullable
    private final Double interestRate;
    @Nullable
    private final Double insuranceRate;
    @Nullable
    private final Periodicity insurancePeriodicity;
    @NotNull
    private final ProductType productType;

    public Asset(@NotNull String tag, double reconBalance, @Nullable Double interestRate, @Nullable Double insuranceRate, @Nullable Periodicity insurancePeriodicity) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.tag = tag;
        this.reconBalance = reconBalance;
        this.interestRate = interestRate;
        this.insuranceRate = insuranceRate;
        this.insurancePeriodicity = insurancePeriodicity;
        this.productType = ProductType.ASSET;
    }

    public /* synthetic */ Asset(String string, double d, Double d2, Double d3, Periodicity periodicity, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            d2 = 0.0;
        }
        if ((n & 8) != 0) {
            d3 = 0.0;
        }
        if ((n & 0x10) != 0) {
            periodicity = Periodicity.YEARLY;
        }
        this(string, d, d2, d3, periodicity);
    }

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @Override
    public double getReconBalance() {
        return this.reconBalance;
    }

    @Nullable
    public final Double getInterestRate() {
        return this.interestRate;
    }

    @Nullable
    public final Double getInsuranceRate() {
        return this.insuranceRate;
    }

    @Nullable
    public final Periodicity getInsurancePeriodicity() {
        return this.insurancePeriodicity;
    }

    @Override
    @NotNull
    public ProductType getProductType() {
        return this.productType;
    }

    @Override
    @NotNull
    public List<PositionCompo> createCompos(@NotNull Portfolio portfolio, @NotNull Position pos) {
        Intrinsics.checkNotNullParameter((Object)portfolio, (String)"portfolio");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        List compos = new ArrayList();
        if (this.interestRate != null && !Intrinsics.areEqual((Double)this.interestRate, (double)0.0)) {
            RevenueAllocation revenueAllocation = RevenueAllocation.PAYOUT;
            ValueProvider<Double> valueProvider = ValueProviders.INSTANCE.eoyBalance(pos);
            ValueProvider<Double> valueProvider2 = ValueProviders.INSTANCE.constValue(this.interestRate);
            compos.add(new InterestCompo(pos, "interest", valueProvider, valueProvider2, revenueAllocation));
        }
        if (this.insuranceRate != null && !Intrinsics.areEqual((Double)this.insuranceRate, (double)0.0)) {
            ValueProvider<Double> valueProvider = ValueProviders.INSTANCE.constValue(this.insuranceRate / 100.0 * this.getReconBalance());
            Periodicity periodicity = this.insurancePeriodicity;
            if (periodicity == null) {
                periodicity = Periodicity.YEARLY;
            }
            compos.add(new CashflowCompo(pos, "insurance", true, valueProvider, -1, periodicity, null, null, true, 192, null));
        }
        return compos;
    }

    @Override
    @NotNull
    public Position createPosition(@NotNull Portfolio portfolio) {
        return Valuable.DefaultImpls.createPosition(this, portfolio);
    }

    @NotNull
    public final String component1() {
        return this.tag;
    }

    public final double component2() {
        return this.reconBalance;
    }

    @Nullable
    public final Double component3() {
        return this.interestRate;
    }

    @Nullable
    public final Double component4() {
        return this.insuranceRate;
    }

    @Nullable
    public final Periodicity component5() {
        return this.insurancePeriodicity;
    }

    @NotNull
    public final Asset copy(@NotNull String tag, double reconBalance, @Nullable Double interestRate, @Nullable Double insuranceRate, @Nullable Periodicity insurancePeriodicity) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return new Asset(tag, reconBalance, interestRate, insuranceRate, insurancePeriodicity);
    }

    public static /* synthetic */ Asset copy$default(Asset asset, String string, double d, Double d2, Double d3, Periodicity periodicity, int n, Object object) {
        if ((n & 1) != 0) {
            string = asset.tag;
        }
        if ((n & 2) != 0) {
            d = asset.reconBalance;
        }
        if ((n & 4) != 0) {
            d2 = asset.interestRate;
        }
        if ((n & 8) != 0) {
            d3 = asset.insuranceRate;
        }
        if ((n & 0x10) != 0) {
            periodicity = asset.insurancePeriodicity;
        }
        return asset.copy(string, d, d2, d3, periodicity);
    }

    @NotNull
    public String toString() {
        return "Asset(tag=" + this.tag + ", reconBalance=" + this.reconBalance + ", interestRate=" + this.interestRate + ", insuranceRate=" + this.insuranceRate + ", insurancePeriodicity=" + this.insurancePeriodicity + ")";
    }

    public int hashCode() {
        int result = this.tag.hashCode();
        result = result * 31 + Double.hashCode(this.reconBalance);
        result = result * 31 + (this.interestRate == null ? 0 : ((Object)this.interestRate).hashCode());
        result = result * 31 + (this.insuranceRate == null ? 0 : ((Object)this.insuranceRate).hashCode());
        result = result * 31 + (this.insurancePeriodicity == null ? 0 : this.insurancePeriodicity.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Asset)) {
            return false;
        }
        Asset asset = (Asset)other;
        if (!Intrinsics.areEqual((Object)this.tag, (Object)asset.tag)) {
            return false;
        }
        if (Double.compare(this.reconBalance, asset.reconBalance) != 0) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.interestRate, (Object)asset.interestRate)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.insuranceRate, (Object)asset.insuranceRate)) {
            return false;
        }
        return this.insurancePeriodicity == asset.insurancePeriodicity;
    }
}

