package io.fincast.pos.model.impl

import io.fincast.pos.model.SimDate
import io.fincast.pos.model.ValueProvider
import io.fincast.pos.model.Position
import io.fincast.pos.model.enums.Periodicity

data class TransferCompo(
	override val position: Position,
	override val tag: String,
	val fromPosition: Position,
	val toPosition: Position,
	val amount: ValueProvider<Double>,
	val sign: Int,
	val periodicity: Periodicity,
	val startDate: SimDate? = null,
	val endDate: SimDate? = null,
) : PositionCompoBase() {

	override fun handleLifecycle(date: SimDate) {
		if (periodicity.isCashflowDate(date, startDate, endDate)) {
			val amount = amount.getValue(date) * sign
			this.bookTransfer(date, fromPosition, toPosition, amount)
		}
	}

}
