package io.fincast.pos.model.impl

import io.fincast.pos.model.SimDate
import io.fincast.pos.model.ValueProvider
import io.fincast.household.model.enums.RevenueAllocation
import io.fincast.pos.model.Position
import io.fincast.pos.model.enums.Periodicity

data class RedemptionCompo(
	override val position: Position,
	override val tag: String,
	val startDate: SimDate,
	val endDate: SimDate,
	val periodicity: Periodicity,
	val revenueAllocation: RevenueAllocation,
	val amount: ValueProvider<Double>,
	val redemptionRate: ValueProvider<Double>
) : PositionCompoBase() {

	override fun handleLifecycle(date: SimDate) {}

}
