package io.fincast.pos.model.impl

import io.fincast.household.model.enums.ProductType
import io.fincast.pos.model.*
import io.fincast.pos.model.enums.BookingKind

class PositionImpl(
	override val portfolio: Portfolio,
	override val tag: String,
	override val productType: ProductType,
) : Position {

	override var compos: List<PositionCompo> = emptyList()

	override fun handlePositionLifecycle(date: SimDate) {
		compos.forEach { it.handleLifecycle(date) }
	}

	override fun handlePortfolioLifecycle(date: SimDate) {
	}

	override fun getBalance(date: SimDate): Double {
		return (portfolio as PortfolioImpl).getBalance(this, date)
	}

	override fun getTurnover(date: SimDate): Double {
		return (portfolio as PortfolioImpl).getTurnover(this, date)
	}

	override fun getInterestAccrual(date: SimDate): Double {
		return (portfolio as PortfolioImpl).getInterestAccrual(this, date)
	}

	override fun getDividendAccrual(date: SimDate): Double {
		return (portfolio as PortfolioImpl).getDividendAccrual(this, date)
	}

	override fun getCapitalGain(date: SimDate): Double {
		return (portfolio as PortfolioImpl).getCapitalGain(this, date)
	}

	override fun getBookings(date: SimDate?): List<Booking> {
		return (portfolio as PortfolioImpl).getBookings(this, date)
	}

	override fun getPeriods(): List<BookingPeriod> {
		return (portfolio as PortfolioImpl).getPeriods(this)
	}

	override fun addReconciliation(date: SimDate, balance: Double) {
		(portfolio as PortfolioImpl).addReconciliation(this, date, balance)
	}

	override fun addTurnover(date: SimDate, turnover: Double) {
		(portfolio as PortfolioImpl).addTurnover(this, date, turnover)
	}

	override fun addBooking(date: SimDate, bookingKind: BookingKind, amount: Double, refPos: Position?) {
		(portfolio as PortfolioImpl).addBooking(this, date, bookingKind, amount, refPos)
	}

}
