package io.fincast.pos.model.impl

import io.fincast.pos.model.SimDate
import io.fincast.pos.model.enums.BookingKind
import io.fincast.pos.model.Position
import io.fincast.pos.model.PositionCompo

abstract class PositionCompoBase : PositionCompo {

	fun bookCashflow(date: SimDate, amount: Double, isViaPocket: Boolean = true) {
		if (amount != 0.0) {
			if (isViaPocket) {
				portfolio.pocketMoney.addBooking(date, BookingKind.TURNOVER, amount, this.position)
			} else {
				position.addBooking(date, BookingKind.TURNOVER, amount)
			}
			portfolio.externalMoney.addBooking(date, BookingKind.TURNOVER, -amount, this.position)
		}
	}

	fun bookTransfer(date: SimDate, from: Position, to: Position, amount: Double) {
		if (amount != 0.0) {
			from.addBooking(date, BookingKind.TRANSFER, amount, this.position)
			to.addBooking(date, BookingKind.TRANSFER, -amount, this.position)
		}
	}

	fun bookInterestAccrual(date: SimDate, accrual: Double, isReinvestment: Boolean) {
		bookAccrual(date, accrual, BookingKind.INTEREST, isReinvestment)
	}

	fun bookDividendAccrual(date: SimDate, accrual: Double, isReinvestment: Boolean) {
		bookAccrual(date, accrual, BookingKind.DIVIDEND, isReinvestment)
	}

	private fun bookAccrual(date: SimDate, accrual: Double, bookingKind: BookingKind, isReinvestment: Boolean) {
		if (accrual != 0.0) {
			portfolio.externalMoney.addBooking(date, bookingKind, -accrual, this.position)
			if (isReinvestment) {
				position.addBooking(date, bookingKind, accrual)
			} else {
				portfolio.pocketMoney.addBooking(date, bookingKind, accrual, this.position)
			}
		}
	}

	fun bookCapitalGain(date: SimDate, capitalGain: Double) {
		if (capitalGain != 0.0) {
			portfolio.externalMoney.addBooking(date, BookingKind.CAPITAL_GAIN, -capitalGain, this.position)
			position.addBooking(date, BookingKind.CAPITAL_GAIN, capitalGain)
		}
	}

}
