package io.fincast.pos.model.impl

import io.fincast.pos.model.SimDate
import io.fincast.pos.model.ValueProvider
import io.fincast.household.model.enums.RevenueAllocation
import io.fincast.pos.model.Position
import io.fincast.pos.model.enums.Periodicity

data class InterestCompo(
	override val position: Position,
	override val tag: String,
	val amount: ValueProvider<Double>,
	val interestRate: ValueProvider<Double>,
	val revenueAllocation: RevenueAllocation,
) : PositionCompoBase() {

	override fun handleLifecycle(date: SimDate) {
		val amount = amount.getValue(date)
		val interestRate = interestRate.getValue(date)
		val accrual = amount * interestRate / 100 / Periodicity.MONTHS_IN_YEAR
		this.bookInterestAccrual(date, accrual, isReinvestment = RevenueAllocation.REINVESTMENT === revenueAllocation)
	}

}
