package io.fincast.pos.model.impl

import io.fincast.pos.model.SimDate
import io.fincast.pos.model.ValueProvider
import io.fincast.household.model.enums.RevenueAllocation
import io.fincast.pos.model.Position
import io.fincast.pos.model.enums.Periodicity

data class DividendCompo(
	override val position: Position,
	override val tag: String,
	val revenueAllocation: RevenueAllocation,
	val dividendYield: ValueProvider<Double>
) : PositionCompoBase() {

	override fun handleLifecycle(date: SimDate) {
		val amount = position.getBalance(date.startOfYear() - 1)
		val dividendYield = dividendYield.getValue(date)
		val accrual = amount * dividendYield / 100 / Periodicity.MONTHS_IN_YEAR
		this.bookDividendAccrual(date, accrual, isReinvestment = RevenueAllocation.REINVESTMENT === revenueAllocation)
	}

}
