package io.fincast.pos.model.impl

import io.fincast.pos.model.SimDate
import io.fincast.pos.model.ValueProvider
import io.fincast.pos.model.Position
import io.fincast.pos.model.enums.Periodicity

/**
 * A cashflow component generates external, incoming or outgoing cashflows.
 * The money lands on / originates from the pocketMoney account.
 */
data class CashflowCompo(
	override val position: Position,
	override val tag: String,
	val isFromPocket: Boolean,
	val amount: ValueProvider<Double>,
	val sign: Int,
	val periodicity: Periodicity,
	val startDate: SimDate? = null,
	val endDate: SimDate? = null,
	val proRata: Boolean = false,
) : PositionCompoBase() {

	override fun handleLifecycle(date: SimDate) {
		if (periodicity.isCashflowDate(date, startDate, endDate)) {
			var amount = amount.getValue(date) * sign
			val sop = periodicity.startOfPeriod(date)
			if (proRata && null != startDate && sop < startDate) {
				amount = amount * (date - startDate) / periodicity.months
			}
			this.bookCashflow(date, amount)
		}
	}

}
