package io.fincast.pos.model.impl

import io.fincast.pos.model.SimDate
import io.fincast.pos.model.ValueProvider
import io.fincast.pos.model.Position
import io.fincast.pos.model.enums.Periodicity

data class CapitalGainCompo(
	override val position: Position,
	override val tag: String,
	val capitalGainRate: ValueProvider<Double>
) : PositionCompoBase() {

	override fun handleLifecycle(date: SimDate) {
		val amount = position.getBalance(date.startOfYear() - 1)
		val capitalGainRate = capitalGainRate.getValue(date)
		val capitalGain = amount * capitalGainRate / 100 / Periodicity.MONTHS_IN_YEAR
		this.bookCapitalGain(date, capitalGain)
	}

}
