package io.fincast.pos.model.enums

import io.fincast.pos.model.SimDate
import java.util.*

enum class Periodicity(val months: Int) {
	UPFRONT(0),
	MATURITY(0),
	MONTHLY(1),
	QUARTERLY(3),
	YEARLY(12);

	fun startOfPeriod(date: SimDate) = if (months == 0) date else SimDate.of(date.year(), (date.month() - 1) / months * months + 1)

	fun endOfPeriod(date: SimDate) = if (months == 0) date else startOfPeriod(date) + months - 1

	fun isCashflowDate(date: SimDate, startDate: SimDate? = null, endDate: SimDate? = null): Boolean {
		if (null != startDate && date < startDate) {
			return false
		} else if (null != endDate && date > endDate) {
			return false
		}
		if (UPFRONT == this) {
			return null != startDate && date == startDate
		} else if (null != endDate && date == endDate) {
			return true
		} else if (MATURITY == this) {
			return false
		}
		assert(0 < months) { "months > 0" }
		return 0 == date.month() % months
	}

	companion object {
		const val MONTHS_IN_YEAR = 12
		fun of(periodicity: String) = valueOf(periodicity.uppercase(Locale.getDefault()))
	}

}
