package io.fincast.pos.model

object ValueProviders {

	fun <T> constValue(value: T): ValueProvider<T> {
		return ValueProvider { value }
	}

	fun eoyBalance(pos: Position): ValueProvider<Double> {
		return ValueProvider { date ->
			return@ValueProvider if (0.0 != pos.getBalance(date)) {
				pos.getBalance(date.startOfYear() - 1)
			} else {
				0.0
			}
		}
	}

	fun eoyCreditBalance(pos: Position): ValueProvider<Double> {
		return ValueProvider { date ->
			return@ValueProvider if (0.0 < pos.getBalance(date)) {
				pos.getBalance(date.startOfYear() - 1).coerceAtLeast(0.0)
			} else {
				0.0
			}
		}
	}

	fun eoyDebitBalance(pos: Position): ValueProvider<Double> {
		return ValueProvider { date ->
			return@ValueProvider if (0.0 > pos.getBalance(date)) {
				pos.getBalance(date.startOfYear() - 1).coerceAtMost(0.0)
			} else {
				0.0
			}
		}
	}

	fun prevEopBalance(pos: Position): ValueProvider<Double> {
		return ValueProvider { date ->
			return@ValueProvider if (0.0 != pos.getBalance(date)) {
				pos.getBalance(date - 1)
			} else {
				0.0
			}
		}
	}

}
