package io.fincast.pos.model

import io.fincast.household.model.enums.ProductType
import io.fincast.pos.model.enums.BookingKind

interface Position {

	val portfolio: Portfolio

	val tag: String

	val productType: ProductType

	val compos: List<PositionCompo>

	fun handlePositionLifecycle(date: SimDate)

	fun handlePortfolioLifecycle(date: SimDate)

	/**
	 * Get EOP balance, with or without EOP transfers
	 *
	 * @param date date
	 * @param withEop include EOP transfers
	 * @return EOP balance
	 */
	fun getBalance(date: SimDate): Double

	fun getTurnover(date: SimDate): Double

	fun getInterestAccrual(date: SimDate): Double

	fun getDividendAccrual(date: SimDate): Double

	fun getCapitalGain(date: SimDate): Double

	fun getBookings(date: SimDate?): List<Booking>

	fun getPeriods(): List<BookingPeriod>

	fun addReconciliation(date: SimDate, balance: Double)

	fun addTurnover(date: SimDate, turnover: Double)

	fun addBooking(date: SimDate, bookingKind: BookingKind, amount: Double, refPos: Position? = null)

}
