package io.fincast.pos.model

import io.fincast.household.model.Holding
import io.fincast.pos.model.impl.PortfolioImpl

interface Portfolio {

	val reconDate: SimDate

	val positions: List<Position>

	val pocketMoney: Position

	val externalMoney: Position

	fun getPositions(tag: String): List<Position>

}

fun createPortfolio(reconDate: SimDate, holdings: List<Holding>): Portfolio {
	val portfolio = PortfolioImpl(reconDate)
	val positions = holdings.map { it.createPosition(portfolio) }
	portfolio.positions = positions
	return portfolio
}
