package io.fincast.pos.model

import io.fincast.pos.model.enums.BookingKind

/**
 * A half-booking on a position.
 *
 * A booking changes the balance (bookingKind.bookingType BALANCE or TURNOVER) or accrual (bookingType.ACCRUAL) of a position.
 */
data class Booking(
	val date: SimDate,
	val bookingKind: BookingKind,
	val amount: Double,
	val refPosition: Position?
) {

	override fun toString(): String {
		return "$bookingKind ${String.format("%.0f", amount)}"
	}

}
