package io.fincast.household.model.impl

import io.fincast.pos.model.ValueProviders.constValue
import io.fincast.household.model.Valuable
import io.fincast.household.model.enums.ProductType
import io.fincast.pos.model.Portfolio
import io.fincast.pos.model.Position
import io.fincast.pos.model.PositionCompo
import io.fincast.pos.model.enums.Periodicity
import io.fincast.pos.model.impl.CashflowCompo

data class RealEstate(
	override val tag: String,
	override val reconBalance: Double, // market value
	val fiscalValue: Double? = null,
	val isSelfOccupied: Boolean? = null,
	val imputedRentalValue: Double? = null,
	val rentalIncome: Double? = null,
	val maintenanceRate: Double? = null,
	val maintenancePeriodicity: Periodicity = Periodicity.YEARLY,
) : Valuable {

	override val productType = ProductType.ASSET

	override fun createCompos(portfolio: Portfolio, pos: Position): List<PositionCompo> {
		val compos: MutableList<PositionCompo> = mutableListOf()
		if (maintenanceRate != null && maintenanceRate != 0.0) {
			compos.add(
				CashflowCompo(
					position = pos,
					tag = "maintenance",
					isFromPocket = true,
					amount = constValue(maintenanceRate / 100.0 * reconBalance),
					sign = -1,
					periodicity = maintenancePeriodicity,
					proRata = true,
				)
			)
		}
		if (rentalIncome != null && rentalIncome != 0.0) {
			compos.add(
				CashflowCompo(
					position = pos,
					tag = "rentalIncome",
					isFromPocket = true,
					amount = constValue(rentalIncome / 12),
					sign = 1,
					periodicity = Periodicity.MONTHLY,
				)
			)
		}
		return compos
	}

}
