package io.fincast.household.model.impl

import io.fincast.pos.model.ValueProviders.constValue
import io.fincast.pos.model.ValueProviders.eoyCreditBalance
import io.fincast.pos.model.ValueProviders.eoyDebitBalance
import io.fincast.household.model.Valuable
import io.fincast.household.model.enums.ProductType
import io.fincast.household.model.enums.RevenueAllocation
import io.fincast.pos.model.Portfolio
import io.fincast.pos.model.Position
import io.fincast.pos.model.PositionCompo
import io.fincast.pos.model.impl.InterestCompo

data class MoneyAccount(
	override val tag: String,
	override val reconBalance: Double = 0.0,
	val creditInterestRate: Double? = 0.0,
	val debitInterestRate: Double? = 0.0,
	val revenueAllocation: RevenueAllocation = RevenueAllocation.REINVESTMENT,
) : Valuable {

	override val productType = ProductType.VALUABLE

	override fun createCompos(portfolio: Portfolio, pos: Position): List<PositionCompo> {
		val compos = mutableListOf<PositionCompo>()
		if (creditInterestRate != null && creditInterestRate != 0.0) {
			compos.add(
				InterestCompo(
					position = pos,
					tag = "creditInterest",
					revenueAllocation = revenueAllocation,
					amount = eoyCreditBalance(pos),
					interestRate = constValue(creditInterestRate)
				)
			)
		}
		if (debitInterestRate != null && debitInterestRate != 0.0) {
			compos.add(
				InterestCompo(
					position = pos,
					tag = "debitInterest",
					revenueAllocation = revenueAllocation,
					amount = eoyDebitBalance(pos),
					interestRate = constValue(debitInterestRate)
				)
			)
		}
		return compos
	}

}
