package io.fincast.household.model.impl

import io.fincast.household.model.Holding
import io.fincast.pos.model.SimDate
import io.fincast.pos.model.impl.PortfolioImpl
import io.fincast.household.model.Household
import io.fincast.household.model.Person
import io.fincast.pos.model.Portfolio
import io.fincast.pos.model.createPortfolio
import javax.sound.sampled.Port

class HouseholdImpl(
	override val persons: List<Person>,
	override val reconDate: SimDate,
	override val holdings: List<Holding>
) : Household {

	override fun calcProjection(endDate: SimDate): Portfolio {

		val portfolio = createPortfolio(reconDate, holdings)

		// don't calc reconDate, it is already reconciled
		for (d in reconDate + 1 .. endDate) {
			// Period Lifecycle: Accrual, Dividends, ...
			//(portfolio as PortfolioImpl).isEop = false
			portfolio.positions.forEach { it.handlePositionLifecycle(d) }
			// End of Period: Transfers
			//(portfolio as PortfolioImpl).isEop = true
			portfolio.positions.forEach { it.handlePortfolioLifecycle(d) }
		}

		//(portfolio as PortfolioImpl).isEop = false

		/*
		 * if (positions.size() == 1) {
		 *
		 * Position pocketMoney = this.getPocketMoney(); Position externalMoney =
		 * this.getExternalMoney(); Position pos = positions.get(0);
		 *
		 * System.out.println("\nPos Booking Periods:");
		 * System.out.println("--------------------"); for (BookingPeriod period :
		 * be.getBookingPeriods(pos)) { System.out.println(period); }
		 *
		 * System.out.println("\nPocketMoney Booking Periods:");
		 * System.out.println("----------------------------"); for (BookingPeriod period
		 * : be.getBookingPeriods(pocketMoney)) { System.out.println(period); }
		 *
		 * System.out.println("\nExternalMoney Booking Periods:");
		 * System.out.println("------------------------------"); for (BookingPeriod
		 * period : be.getBookingPeriods(externalMoney)) { System.out.println(period); }
		 *
		 * System.out.println("\nSimulation Periods:");
		 * System.out.println("-------------------"); for (ProjectionPeriod period :
		 * periods) { System.out.println(period); }
		 *
		 * }
		 */

		return portfolio

	}

}
