package io.fincast.household.model.impl

import io.fincast.household.model.Contract
import io.fincast.household.model.enums.ProductType
import io.fincast.pos.model.*
import io.fincast.pos.model.enums.Periodicity
import io.fincast.pos.model.impl.CashflowCompo

data class Expense(
	override val tag: String,
	val amount: ValueProvider<Double>,
	val periodicity: Periodicity? = Periodicity.YEARLY,
	override val startDate: SimDate? = null,
	override val endDate: SimDate? = null,
) : Contract {

	override val productType = ProductType.EXPENSE

	override fun createCompos(portfolio: Portfolio, pos: Position): List<PositionCompo> {
		val startDate = SimDate.max(startDate ?: portfolio.reconDate, portfolio.reconDate)
		val cf = CashflowCompo(
			position = pos,
			tag = "expense",
			isFromPocket = true,
			amount = amount,
			sign = -1,
			startDate = startDate,
			endDate = endDate,
			periodicity = periodicity ?: Periodicity.YEARLY,
			proRata = true,
		)
		return listOf(cf)
	}

}
