package io.fincast.household.model.impl

import io.fincast.pos.model.ValueProviders.constValue
import io.fincast.pos.model.ValueProviders.eoyBalance
import io.fincast.household.model.Valuable
import io.fincast.household.model.enums.ProductType
import io.fincast.household.model.enums.RevenueAllocation
import io.fincast.pos.model.Portfolio
import io.fincast.pos.model.Position
import io.fincast.pos.model.PositionCompo
import io.fincast.pos.model.enums.Periodicity
import io.fincast.pos.model.impl.CashflowCompo
import io.fincast.pos.model.impl.InterestCompo

data class Asset(
	override val tag: String,
	override val reconBalance: Double,
	val interestRate: Double? = 0.0,
	val insuranceRate: Double? = 0.0,
	val insurancePeriodicity: Periodicity? = Periodicity.YEARLY,
) : Valuable {

	override val productType = ProductType.ASSET

	override fun createCompos(portfolio: Portfolio, pos: Position): List<PositionCompo> {
		val compos: MutableList<PositionCompo> = mutableListOf()
		if (interestRate != null && interestRate != 0.0) {
			compos.add(
				InterestCompo(
					position = pos,
					tag = "interest",
					revenueAllocation = RevenueAllocation.PAYOUT,
					amount = eoyBalance(pos),
					interestRate = constValue(interestRate)
				)
			)
		}
		if (insuranceRate != null && insuranceRate != 0.0) {
			compos.add(
				CashflowCompo(
					position = pos,
					tag = "insurance",
					isFromPocket = true,
					amount = constValue(insuranceRate / 100.0 * reconBalance),
					sign = -1,
					periodicity = insurancePeriodicity ?: Periodicity.YEARLY,
					proRata = true,
				)
			)
		}
		return compos
	}

}
