package io.fincast.household.model

import io.fincast.pos.model.Portfolio
import io.fincast.pos.model.Position

interface Valuable : Holding {

	val reconBalance: Double

	override fun createPosition(portfolio: Portfolio): Position {
		val pos = super.createPosition(portfolio)
		if (0.0 != reconBalance) {
			pos.addReconciliation(portfolio.reconDate, reconBalance)
		}
		return pos
	}

}
