package io.fincast.household.model

import io.fincast.household.model.impl.HouseholdImpl
import io.fincast.pos.model.Portfolio
import io.fincast.pos.model.SimDate

interface Household {

	val persons: List<Person>

	val reconDate: SimDate

	val holdings: List<Holding>

	fun calcProjection(endDate: SimDate): Portfolio

}

fun createHousehold(persons: List<Person>, reconDate: SimDate, holdings: List<Holding>): Household {
	return HouseholdImpl(persons, reconDate, holdings)
}
