package io.fincast.household.model

import io.fincast.household.model.enums.ProductType
import io.fincast.pos.model.Portfolio
import io.fincast.pos.model.Position
import io.fincast.pos.model.PositionCompo
import io.fincast.pos.model.impl.PositionImpl

interface Holding {

	val tag: String

	val productType: ProductType

	fun createPosition(portfolio: Portfolio): Position {
		val pos = PositionImpl(portfolio, tag, productType)
		pos.compos = createCompos(portfolio, pos)
		return pos
	}

	fun createCompos(portfolio: Portfolio, pos: Position): List<PositionCompo>

}
