package io.dddrive.core.property.model.impl;

import static io.dddrive.util.Invariant.assertThis;
import static io.dddrive.util.Invariant.requireThis;

import java.util.Objects;

import io.dddrive.core.ddd.model.Aggregate;
import io.dddrive.core.property.model.AggregateResolver;
import io.dddrive.core.property.model.EntityWithProperties;
import io.dddrive.core.property.model.ReferenceProperty;
import io.dddrive.core.property.model.base.PropertyBase;

public class ReferencePropertyImpl<A extends Aggregate> extends PropertyBase<A> implements ReferenceProperty<A> {

	private final AggregateResolver<A> resolver;
	private Object value;

	public ReferencePropertyImpl(EntityWithProperties entity, String name, AggregateResolver<A> resolver) {
		super(entity, name);
		this.resolver = resolver;
	}

	@Override
	public Object getId() {
		return this.value;
	}

	@Override
	public void setId(Object id) {
		requireThis(this.isWritable(), "not frozen");
		if (Objects.equals(this.getId(), id)) {
			return;
		}
		assertThis(this.isValidAggregateId(id), "valid aggregate id [" + id + "]");
		this.value = id;
		this.getEntity().doAfterSet(this);
	}

	@Override
	public A getValue() {
		return this.getId() == null ? null : this.resolver.get(this.getId());
	}

	@Override
	public void setValue(A value) {
		this.setId(value == null ? null : value.getId());
	}

	// TODO too expensive?
	private boolean isValidAggregateId(Object id) {
		return true;
	}

}
