package io.dddrive.core.property.model.impl;

import static io.dddrive.util.Invariant.requireThis;

import java.util.Objects;

import io.dddrive.core.property.model.BaseProperty;
import io.dddrive.core.property.model.EntityWithProperties;
import io.dddrive.core.property.model.base.PropertyBase;

public class BasePropertyImpl<T> extends PropertyBase<T> implements BaseProperty<T> {

	private T value;

	public BasePropertyImpl(EntityWithProperties entity, String name) {
		super(entity, name);
	}

	@Override
	public T getValue() {
		return this.value;
	}

	@Override
	public void setValue(T value) {
		requireThis(this.isWritable(), "not frozen");
		if (Objects.equals(this.value, value)) {
			return;
		}
		this.value = value;
		this.getEntity().doAfterSet(this);
	}

}
