package io.dddrive.core.property.model;

import java.util.List;

import io.dddrive.core.ddd.model.Part;

public interface PartListProperty<P extends Part<?>> extends Property<P> {

	Class<P> getPartType();

	Integer getPartCount();

	P getPart(Integer seqNr);

	P getPartById(Integer partId);

	List<P> getParts();

	void clearParts();

	P addPart();

	void removePart(Integer partId);

	void removePart(P part);

	void loadItems(List<? extends Part<?>> partList);

}
