package io.dddrive.core.property.model;

import java.util.List;

import io.dddrive.core.ddd.model.Part;
import io.dddrive.core.ddd.model.RepositoryDirectory;

public interface EntityWithProperties {

	RepositoryDirectory getDirectory();

	boolean hasProperty(String name);

	Property<?> getProperty(String name);

	List<Property<?>> getProperties();

	boolean isFrozen();

	Part<?> doAddPart(Property<?> property);

	void doAfterSet(Property<?> property);

	void doAfterClear(Property<?> property);

	void doAfterAdd(Property<?> property, Part<?> part);

	void doAfterRemove(Property<?> property);

}
