package io.dddrive.core.obj.model.base;

import java.time.OffsetDateTime;

import io.dddrive.core.ddd.model.AggregateRepository;
import io.dddrive.core.ddd.model.base.AggregateRepositoryBase;
import io.dddrive.core.obj.model.Obj;
import io.dddrive.core.obj.model.ObjPartTransition;
import io.dddrive.core.obj.model.ObjRepository;

public abstract class ObjRepositoryBase<O extends Obj>
		extends AggregateRepositoryBase<O>
		implements ObjRepository<O> {

	//private ObjPartTransitionRepository transitionRepository;
	//private ObjPartItemRepository itemRepository;

	protected ObjRepositoryBase(
			Class<? extends AggregateRepository<O>> repoIntfClass,
			Class<? extends Obj> intfClass,
			Class<? extends Obj> baseClass,
			String aggregateTypeId) {
		super(repoIntfClass, intfClass, baseClass, aggregateTypeId);
	}

	@Override
	public void registerParts() {
		this.addPart(Obj.class, ObjPartTransition.class, ObjPartTransitionBase.class);
	}

	//	@Override
//	public ObjPartTransitionRepository getTransitionRepository() {
//		return this.transitionRepository;
//	}

//	@Autowired
//	void setTransitionRepository(ObjPartTransitionRepository transitionRepository) {
//		this.transitionRepository = transitionRepository;
//	}

//	@Override
//	public ObjPartItemRepository getItemRepository() {
//		return this.itemRepository;
//	}

//	@Autowired
//	void setItemRepository(ObjPartItemRepository itemRepository) {
//		this.itemRepository = itemRepository;
//	}

//	@Override
//	@PostConstruct
//	public void registerPartRepositories() {
//		this.addPartRepository(this.transitionRepository);
//		this.addPartRepository(this.itemRepository);
//	}

	@Override
	public void delete(O obj, Object userId, OffsetDateTime timestamp) {
		obj.delete(userId, timestamp);
		this.store(obj, userId, timestamp);
	}

}
