package io.dddrive.core.doc.model.base;

import io.dddrive.core.ddd.model.AggregateRepository;
import io.dddrive.core.ddd.model.base.AggregateRepositoryBase;
import io.dddrive.core.doc.model.Doc;
import io.dddrive.core.doc.model.DocPartTransition;
import io.dddrive.core.doc.model.DocRepository;

public abstract class DocRepositoryBase<D extends Doc>
		extends AggregateRepositoryBase<D>
		implements DocRepository<D> {

	//private DocPartTransitionRepository transitionRepository;
	//private DocPartItemRepository itemRepository;

	protected DocRepositoryBase(
			Class<? extends AggregateRepository<D>> repoIntfClass,
			Class<? extends Doc> intfClass,
			Class<? extends Doc> baseClass,
			String aggregateTypeId) {
		super(repoIntfClass, intfClass, baseClass, aggregateTypeId);
	}

	@Override
	public void registerParts() {
		this.addPart(Doc.class, DocPartTransition.class, DocPartTransitionBase.class);
	}

//	@Override
//	public DocPartTransitionRepository getTransitionRepository() {
//		return this.transitionRepository;
//	}

//	@Autowired
//	void setTransitionRepository(DocPartTransitionRepository transitionRepository) {
//		this.transitionRepository = transitionRepository;
//	}

//	@Override
//	public DocPartItemRepository getItemRepository() {
//		return this.itemRepository;
//	}

//	@Autowired
//	void setItemRepository(DocPartItemRepository itemRepository) {
//		this.itemRepository = itemRepository;
//	}

//	@Override
//	@PostConstruct
//	public void registerPartRepositories() {
//		this.addPartRepository(this.getTransitionRepository());
//		this.addPartRepository(this.getItemRepository());
//	}

}
