package io.dddrive.core.ddd.model.base;

import static io.dddrive.util.Invariant.assertThis;

import java.util.HashMap;
import java.util.Map;

import io.dddrive.core.ddd.model.Aggregate;
import io.dddrive.core.ddd.model.AggregateRepository;
import io.dddrive.core.ddd.model.Part;
import io.dddrive.core.ddd.model.PartRepository;
import io.dddrive.core.ddd.model.RepositoryDirectory;
import io.dddrive.core.ddd.model.RepositoryDirectorySPI;
import io.dddrive.core.enums.model.Enumerated;
import io.dddrive.core.enums.model.Enumeration;

public abstract class RepositoryDirectoryBase implements RepositoryDirectory, RepositoryDirectorySPI {

	private final Map<String, Enumeration<? extends Enumerated>> enumsById = new HashMap<>();
	private final Map<Class<? extends Enumerated>, Enumeration<? extends Enumerated>> enumsByEnumeratedClass = new HashMap<>();
	private final Map<Class<? extends Enumeration<?>>, Enumeration<? extends Enumerated>> enumsByEnumerationClass = new HashMap<>();

	private final Map<Class<? extends Aggregate>, AggregateRepository<?>> repoByIntf = new HashMap<>();
	private final Map<Class<? extends Part<?>>, PartRepository<?, ?>> partRepoByIntf = new HashMap<>();

	@Override
	public Enumeration<? extends Enumerated> getEnumeration(String module, String name) {
		return this.enumsById.get(module + "." + name + "Enum");
	}

	@Override
	@SuppressWarnings("unchecked")
	public <E extends Enumerated> Enumeration<E> getEnumeration(Class<E> enumClass) {
		return (Enumeration<E>) this.enumsByEnumeratedClass.get(enumClass);
	}

//	@Override
//	public <E extends Enumerated> E getEnumerated(Class<E> enumClass, String itemId) {
//		return this.getEnumeration(enumClass).getItem(itemId);
//	}

	@Override
	@SuppressWarnings("unchecked")
	public <E extends Enumerated> void addEnumeration(Class<E> enumeratedClass, Enumeration<E> e) {
		this.enumsById.put(e.getModule() + "." + e.getId(), e);
		this.enumsByEnumerationClass.put((Class<Enumeration<E>>) e.getClass(), e);
		this.enumsByEnumeratedClass.put(enumeratedClass, e);
	}

	@Override
	@SuppressWarnings("unchecked")
	public <A extends Aggregate> AggregateRepository<A> getRepository(Class<A> intfClass) {
		return (AggregateRepository<A>) this.repoByIntf.get(intfClass);
	}

	@Override
	public void addRepository(Class<? extends Aggregate> intfClass, AggregateRepository<? extends Aggregate> repo) {
		assertThis(this.getRepository(intfClass) == null, "unique repo for class " + intfClass);
		this.repoByIntf.put(intfClass, repo);
	}

	@Override
	@SuppressWarnings("unchecked")
	public <A extends Aggregate, P extends Part<A>> PartRepository<A, P> getPartRepository(Class<P> intfClass) {
		return (PartRepository<A, P>) this.partRepoByIntf.get(intfClass);
	}

	@Override
	public <A extends Aggregate> void addPartRepository(Class<? extends Part<A>> intfClass, PartRepository<A, ? extends Part<A>> repo) {
		//assertThis(this.getPartRepository(intfClass) == null, "unique repo for class " + intfClass);
		this.partRepoByIntf.put(intfClass, repo);
	}

}
