package io.dddrive.core.ddd.model.base;

import io.dddrive.core.ddd.model.Aggregate;
import io.dddrive.core.ddd.model.AggregateRepositorySPI;
import io.dddrive.core.ddd.model.Part;
import io.dddrive.core.ddd.model.PartRepository;
import io.dddrive.core.property.model.impl.PropertyFilter;
import io.dddrive.core.property.model.impl.PropertyHandler;
import javassist.util.proxy.ProxyFactory;

public class PartRepositoryBase<A extends Aggregate, P extends Part<A>> implements PartRepository<A, P> {

	private final Class<? extends P> intfClass;
	private final Class<? extends P> baseClass;
	private final ProxyFactory partProxyFactory;
	private final Class<?>[] partProxyFactoryParamTypeList;

	protected PartRepositoryBase(Class<? extends A> aggregateIntfClass, Class<? extends P> intfClass, Class<? extends P> baseClass) {
		this.intfClass = intfClass;
		this.baseClass = baseClass;
		this.partProxyFactory = new ProxyFactory();
		this.partProxyFactory.setSuperclass(baseClass);
		this.partProxyFactory.setFilter(PropertyFilter.INSTANCE);
		this.partProxyFactoryParamTypeList = new Class<?>[]{aggregateIntfClass, Integer.class};
	}

	@Override
	@SuppressWarnings("unchecked")
	public P create(A aggregate) {
		AggregateRepositorySPI<A> repo = (AggregateRepositorySPI<A>) aggregate.getMeta().getRepository();
		Integer id = aggregate.getMeta().isInLoad() ? 0 : repo.getPersistenceProvider().nextPartId(this.intfClass);
		try {
			return (P) this.partProxyFactory.create(this.partProxyFactoryParamTypeList, new Object[]{aggregate, id}, PropertyHandler.INSTANCE);
		} catch (ReflectiveOperationException | RuntimeException e) {
			throw new RuntimeException("Could not create aggregate " + this.baseClass.getSimpleName(), e);
		}
	}

}
