package io.dddrive.core.ddd.model;

/**
 * A Part is an Entity that belongs to an Aggregate (but might be attached to another part as parent).
 */
public interface Part<A extends Aggregate> {

	A getAggregate();

	Integer getId();

	/**
	 * Calculate all the derived fields, typically after a field change.
	 */
	void calcAll();

	/**
	 * Calculate all the volatile derived fields, i.e. fields that are not saved to
	 * the database. This is triggered after loading the aggregate from the
	 * database.
	 */
	void calcVolatile();

}
